/*
 * Decompiled with CFR 0.152.
 */
package Utilities;

import UI_Desktop.Cutter;
import UI_Script.Rib.RibTokenizer;
import Utilities.DocumentUtils;
import Utilities.EnvUtils;
import Utilities.NumberUtils;
import Utilities.RegExpUtils;
import Utilities.VectorUtils;
import java.awt.Color;
import java.awt.Font;
import java.text.Collator;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;
import kernal.Tokenizers.FindReplaceTokenizer;
import kernal.Tokenizers.Tokenizer;

public class TextUtils {
    static Font helvetica12Bold = new Font("Helvetica", 1, 12);
    public static boolean debug_format = false;

    public static String replace_USER_HOME(String src) {
        if (src.trim().length() == 0) {
            return src;
        }
        String username = EnvUtils.getUsersAccountName();
        String userhome = EnvUtils.getUsersHomeDir();
        String temp = RegExpUtils.replaceAllUsingRegExp(src, "(?:\\B)(\\$USER)(?:\\b)", username);
        String replacement = RegExpUtils.replaceAllUsingRegExp(temp, "(?:\\B)(\\$HOME)(?:\\b)", userhome);
        return replacement;
    }

    public static boolean isInList(String[] list, String target) {
        if (list == null) {
            return false;
        }
        for (int n = 0; n < list.length; ++n) {
            if (!list[n].equals(target)) continue;
            return true;
        }
        return false;
    }

    public static synchronized boolean contains(String str, char c) {
        if (str == null) {
            return false;
        }
        return str.indexOf(c, 0) != -1;
    }

    public static synchronized char[] contains(String str, String pattern) {
        return TextUtils.contains(str, pattern.toCharArray());
    }

    public static synchronized char[] contains(String str, char[] ar) {
        int i;
        Vector<Character> list = new Vector<Character>();
        for (i = 0; i < ar.length; ++i) {
            if (str.indexOf(ar[i], 0) == -1) continue;
            list.addElement(Character.valueOf(ar[i]));
        }
        if (list.size() == 0) {
            return null;
        }
        char[] out = new char[list.size()];
        for (i = 0; i < list.size(); ++i) {
            out[i] = ((Character)list.elementAt(i)).charValue();
        }
        return out;
    }

    static synchronized boolean contains(Segment segment, char c) {
        for (int n = 0; n < segment.count; ++n) {
            if (segment.array[n + segment.offset] != c) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(String src, String target, boolean ignoreCase) {
        boolean count = false;
        String[] tokens = TextUtils.tokenize(src);
        if (tokens == null) {
            return false;
        }
        for (int n = 0; n < tokens.length; ++n) {
            if (!ignoreCase && tokens[n].compareTo(target) == 0) {
                return true;
            }
            if (!ignoreCase || !tokens[n].equalsIgnoreCase(target)) continue;
            return true;
        }
        return false;
    }

    public static int count(String src, char c) {
        String[] s = TextUtils.tokenize(src, c);
        return s == null ? -1 : s.length;
    }

    public static String getPrefixSpaces(String src) {
        StringBuffer b = new StringBuffer();
        for (int n = 0; n < src.length(); ++n) {
            if (!Character.isWhitespace(src.charAt(n))) {
                return b.toString();
            }
            b.append(src.charAt(n));
        }
        return b.toString();
    }

    public static String trimInt(String str) {
        StringBuffer buf = new StringBuffer();
        for (int n = 0; n < str.length(); ++n) {
            if (!Character.isDigit(str.charAt(n))) continue;
            buf.append(str.charAt(n));
        }
        return buf.toString();
    }

    public static boolean containsWhiteSpace(String str) {
        if (str == null || str.trim().length() == 0) {
            return false;
        }
        for (int n = 0; n < str.length(); ++n) {
            if (!Character.isWhitespace(str.charAt(n))) continue;
            return true;
        }
        return false;
    }

    static String append(String input, String addition) {
        return input + addition;
    }

    public static String addNewlines(String input) {
        StringBuffer output = new StringBuffer(input);
        for (int n = 0; n < output.length(); ++n) {
            if (output.charAt(n) != '\r' || n + 1 >= output.length() || output.charAt(n + 1) == '\n') continue;
            output.insert(n, '\n');
            ++n;
        }
        return output.toString();
    }

    public static String addQuotes(String input) {
        StringBuffer output = new StringBuffer(input.length() + 2);
        output.append('\"');
        output.append(input);
        output.append('\"');
        return output.toString();
    }

    public static String removeQuotes(String input) {
        return TextUtils.remove(input, '\"');
    }

    public static String[] removeQuotes(String[] input) {
        String[] out = new String[input.length];
        for (int n = 0; n < out.length; ++n) {
            out[n] = TextUtils.removeQuotes(input[n]);
        }
        return out;
    }

    public static String replace(String src, char target, String replacement) {
        StringBuffer out = new StringBuffer();
        for (int n = 0; n < src.length(); ++n) {
            char c = src.charAt(n);
            if (c == target) {
                out.append(replacement);
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    public static String replaceAll(String src, String str, String destStr, boolean ignoreCase, boolean wholeWord) {
        FindReplaceTokenizer tok = new FindReplaceTokenizer();
        tok.setBuffer(src);
        int[] offset = tok.searchFor(str, ignoreCase, wholeWord);
        if (offset == null) {
            return src;
        }
        int length = src.length();
        int destLngth = destStr.length();
        PlainDocument doc = new PlainDocument();
        try {
            doc.insertString(0, src, null);
        }
        catch (BadLocationException e) {
            Cutter.setLog("    Error: TextUtils.replaceAll() " + e);
            return null;
        }
        for (int begin = offset[0]; begin < length; begin += offset[0]) {
            try {
                doc.remove(begin, offset[1] - offset[0]);
                doc.insertString(begin, destStr, null);
            }
            catch (BadLocationException ex) {
                Cutter.setLog("    Exception: BBxt.replaceAll(String) - " + ex.getMessage());
            }
            length = doc.getLength();
            tok.setBuffer(DocumentUtils.getSegment((Document)doc, begin += destLngth, length - begin));
            offset = tok.searchFor(str, ignoreCase, wholeWord);
            if (offset == null) break;
        }
        try {
            src = doc.getText(0, doc.getLength());
        }
        catch (BadLocationException e) {
            Cutter.setLog("    Error: TextUtils.replaceAll() " + e);
            return null;
        }
        return src;
    }

    public static String replace(String src, String target, String replacement) {
        String tmp;
        int n;
        StringBuffer out = new StringBuffer();
        int targetLen = target.length();
        int srcLen = src.length();
        int prevOffset = 0;
        for (n = 0; n < srcLen; ++n) {
            char c = src.charAt(n);
            if (c != target.charAt(0) || srcLen <= n + targetLen) continue;
            tmp = src.substring(prevOffset, n);
            out.append(tmp);
            out.append(replacement);
            prevOffset = (n += targetLen - 1) + 1;
        }
        tmp = src.substring(prevOffset, n);
        out.append(tmp);
        return out.toString();
    }

    public static boolean search(boolean ignoreCase, String[] list, String str) {
        if (list == null || list.length == 0) {
            return false;
        }
        for (int n = 0; n < list.length; ++n) {
            if (!TextUtils.search(ignoreCase, list[n], str)) continue;
            return true;
        }
        return false;
    }

    public static boolean search(boolean ignoreCase, String str1, String str2) {
        String s1 = new String(str1);
        String s2 = new String(str2);
        if (s1.length() == s2.length()) {
            if (ignoreCase && s1.equalsIgnoreCase(s2)) {
                return true;
            }
            return !ignoreCase && s1.equals(s2);
        }
        String shortStr = s1.length() < s2.length() ? s1 : s2;
        String longStr = s1.length() > s2.length() ? s1 : s2;
        for (int n = 0; n < Math.abs(longStr.length() - shortStr.length()); ++n) {
            if (!longStr.regionMatches(true, n, shortStr, 0, shortStr.length())) continue;
            return true;
        }
        return false;
    }

    public static Double toDouble(String str) {
        if (str == null || str.length() == 0) {
            return null;
        }
        try {
            return Double.valueOf(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Color toColor(String str) {
        if (str == null || str.length() == 0) {
            return null;
        }
        String[] comp = TextUtils.tokenize(str);
        if (comp == null || comp.length != 3) {
            return null;
        }
        try {
            return new Color(Integer.parseInt(comp[0]), Integer.parseInt(comp[1]), Integer.parseInt(comp[2]));
        }
        catch (Exception e) {
            Cutter.setLog("    Exception: TextUtils.toColor() - cannot convert \"" + str + "\" into a color");
            return null;
        }
    }

    public static String _extractTextBetween(Object src, String start, String end) {
        int endOffset;
        RibTokenizer tok = new RibTokenizer();
        tok.setBuffer((String)src);
        int startOffset = start == null ? 0 : tok.searchFor(start, true);
        int n = endOffset = end == null ? ((String)src).length() - 1 : tok.searchFor(end, false);
        if (startOffset == -1 || endOffset == -1) {
            return null;
        }
        return ((String)src).substring(startOffset, endOffset);
    }

    public static String removeExtension(String input) {
        int index = input.lastIndexOf(".");
        if (index != -1) {
            return input.substring(0, input.lastIndexOf("."));
        }
        return input;
    }

    public static String getTabString(int num) {
        StringBuffer tabBuff = new StringBuffer();
        for (int n = 0; n < num; ++n) {
            tabBuff.append('\t');
        }
        return tabBuff.toString();
    }

    public static String remove(String input, char ch) {
        StringBuffer out = new StringBuffer();
        for (int n = 0; n < input.length(); ++n) {
            char c = input.charAt(n);
            if (c == ch) continue;
            out.append(c);
        }
        return new String(out);
    }

    public static int[] sortIntsAscending(String[] ints) {
        if (ints == null || ints.length == 0) {
            return null;
        }
        Vector<Integer> listOfIntegers = new Vector<Integer>();
        for (int n = 0; n < ints.length; ++n) {
            try {
                int val = NumberUtils.strToInt(ints[n]);
                listOfIntegers.add(val);
                continue;
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        if (listOfIntegers.size() == 0) {
            return null;
        }
        int[] int_arr = new int[listOfIntegers.size()];
        for (int n = 0; n < listOfIntegers.size(); ++n) {
            int_arr[n] = (Integer)listOfIntegers.elementAt(n);
        }
        Arrays.sort(int_arr);
        return int_arr;
    }

    public static String[] sortByAlpha(String[] src) {
        if (src == null) {
            return null;
        }
        Collator collator = Collator.getInstance(Locale.ENGLISH);
        for (int n = 0; n < src.length; ++n) {
            for (int i = n + 1; i < src.length; ++i) {
                if (collator.compare(src[n], src[i]) <= 0) continue;
                String tmp = src[n];
                src[n] = src[i];
                src[i] = tmp;
            }
        }
        return src;
    }

    public static String trim(String src, String trimmer) {
        StringBuffer buff = new StringBuffer();
        boolean hit = false;
        boolean trimDone = false;
        for (int n = 0; n < src.length(); ++n) {
            char c = src.charAt(n);
            if (c < '\t' || c > '\t' && c < ' ' || c > '\u007f') continue;
            if (!trimDone) {
                hit = false;
                if (trimmer.indexOf(c) >= 0) {
                    hit = true;
                }
                if (!hit) {
                    trimDone = true;
                }
            }
            if (!trimDone || c == '\t') continue;
            buff.append(c);
        }
        return buff.toString().trim();
    }

    public static String[] trim(String[] src) {
        if (src == null) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        for (int n = 0; n < src.length; ++n) {
            v.addElement(src[n].trim());
        }
        return VectorUtils.toStringArray(v);
    }

    public static String reverse(char[] chars) {
        return TextUtils.reverse(new String(chars));
    }

    public static String reverse(String src) {
        StringBuffer buff = new StringBuffer();
        for (int n = src.length() - 1; n >= 0; --n) {
            buff.append(src.charAt(n));
        }
        return buff.toString();
    }

    public static String trimLeadingChar(String src, char c) {
        if (src == null) {
            return null;
        }
        if (!src.startsWith("" + c)) {
            return src;
        }
        return TextUtils.trimLeadingChar(src.substring(1), c);
    }

    public static String trimLeadingChars(String src, String leadingChars) {
        if (src == null) {
            return null;
        }
        if (leadingChars == null) {
            return src;
        }
        for (int n = 0; n < leadingChars.length(); ++n) {
            src = TextUtils.trimLeadingChar(src, leadingChars.charAt(n));
        }
        return src;
    }

    public static String trimTrailingChar(String src, char c) {
        if (src == null || !src.endsWith("" + c)) {
            return src;
        }
        return TextUtils.trimTrailingChar(src.substring(0, src.length() - 1), c);
    }

    public static StringBuffer trimTrailingChar(StringBuffer buf, char c) {
        int len = buf.length() - 1;
        if (buf == null || buf.charAt(len) != c) {
            return buf;
        }
        return TextUtils.trimTrailingChar(buf.deleteCharAt(len), c);
    }

    public static String trimTrailingChars(String src, String trailingChars) {
        if (src == null || trailingChars == null) {
            return src;
        }
        for (int n = 0; n < trailingChars.length(); ++n) {
            src = TextUtils.trimTrailingChar(src, trailingChars.charAt(n));
        }
        return src;
    }

    public static String getInnerQuotedString(String src) {
        int end = src.lastIndexOf(34);
        if (end == -1) {
            return null;
        }
        String copy = src.substring(0, end);
        int begin = copy.lastIndexOf(34);
        if (begin == -1) {
            return null;
        }
        copy = src.substring(begin + 1, end);
        return copy;
    }

    public static String getInnerSqBracedString(String src) {
        int begin = src.indexOf(91);
        if (begin == -1) {
            return null;
        }
        int end = src.indexOf(93);
        if (end == -1) {
            return null;
        }
        return src.substring(begin + 1, end);
    }

    public static String getInnerCurlyBracedString(String src) {
        int begin = src.indexOf(123);
        if (begin == -1) {
            return null;
        }
        int end = src.indexOf(125);
        if (end == -1) {
            return null;
        }
        return src.substring(begin + 1, end);
    }

    public static String removeAll(String source, String target) {
        if (source == null) {
            return null;
        }
        if (target == null) {
            return source;
        }
        String oldStr = source;
        RibTokenizer tok = new RibTokenizer();
        tok.setBuffer(source);
        String newStr = tok.remove(target);
        while (newStr != null) {
            oldStr = newStr;
            tok.setBuffer(oldStr);
            newStr = tok.remove(target);
        }
        return oldStr.trim() + "\n";
    }

    public static String getDateTime(int unit) {
        Calendar calendar = Calendar.getInstance();
        return "" + calendar.get(unit);
    }

    public static String getTimeOfDay() {
        Calendar calendar = Calendar.getInstance();
        String date = "";
        date = date + calendar.get(10) + ".";
        date = date + calendar.get(12) + ":";
        date = date + calendar.get(13);
        date = calendar.get(9) == 0 ? date + "AM" : date + "PM";
        return date;
    }

    public static String getDate() {
        Calendar calendar = Calendar.getInstance();
        String date = "";
        date = date + TextUtils.dayToString(calendar) + " ";
        date = date + calendar.get(5) + " ";
        date = date + TextUtils.monthToString(calendar) + " ";
        date = date + calendar.get(1);
        return date;
    }

    private static String monthToString(Calendar calendar) {
        String s = "";
        switch (calendar.get(2)) {
            case 0: {
                s = "Jan";
                break;
            }
            case 1: {
                s = "Feb";
                break;
            }
            case 2: {
                s = "Mar";
                break;
            }
            case 3: {
                s = "Apr";
                break;
            }
            case 4: {
                s = "May";
                break;
            }
            case 5: {
                s = "Jun";
                break;
            }
            case 6: {
                s = "Jul";
                break;
            }
            case 7: {
                s = "Aug";
                break;
            }
            case 8: {
                s = "Sep";
                break;
            }
            case 9: {
                s = "Oct";
                break;
            }
            case 10: {
                s = "Nov";
                break;
            }
            case 11: {
                s = "Dec";
            }
        }
        return s;
    }

    private static String dayToString(Calendar calendar) {
        String s = "";
        switch (calendar.get(7)) {
            case 1: {
                s = "Sun";
                break;
            }
            case 2: {
                s = "Mon";
                break;
            }
            case 3: {
                s = "Tue";
                break;
            }
            case 4: {
                s = "Wed";
                break;
            }
            case 5: {
                s = "Thu";
                break;
            }
            case 6: {
                s = "Fri";
                break;
            }
            case 7: {
                s = "Sat";
            }
        }
        return s;
    }

    public static String getDateTime() {
        return TextUtils.getDateTime(false);
    }

    public static String getDateTime(boolean includeMillis) {
        Calendar calendar = Calendar.getInstance();
        String date = "";
        date = date + calendar.get(1) + "_";
        Integer integer = 2;
        int month = 1 + integer;
        date = date + month + "_";
        date = date + calendar.get(5) + "_";
        date = date + calendar.get(10) + ".";
        date = date + calendar.get(12) + ":";
        date = date + calendar.get(13);
        if (includeMillis) {
            date = date + calendar.get(14);
        }
        return date;
    }

    public static String[] tokenizeAll(String input) {
        Vector<String> lines = new Vector<String>();
        StringBuffer buf = new StringBuffer();
        for (int n = 0; n < input.length(); ++n) {
            if (input.charAt(n) == '\n') {
                lines.addElement(buf.toString());
                buf.setLength(0);
                continue;
            }
            buf.append(input.charAt(n));
        }
        if (buf.length() > 0) {
            lines.addElement(buf.toString());
        }
        return VectorUtils.toStringArray(lines);
    }

    public static String[] tokenize(String input) {
        if (input == null || input.length() == 0 || input.trim().length() == 0) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        StringTokenizer t = new StringTokenizer(input);
        while (t.hasMoreTokens()) {
            v.addElement(t.nextToken());
        }
        String[] cmd = new String[v.size()];
        for (int i = 0; i < cmd.length; ++i) {
            cmd[i] = (String)v.elementAt(i);
        }
        return cmd;
    }

    public static String[] tokenize(String input, char c) {
        if (input == null || input.length() == 0 || input.trim().length() == 0) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        StringTokenizer t = new StringTokenizer(input, "" + c);
        while (t.hasMoreTokens()) {
            v.addElement(t.nextToken());
        }
        String[] cmd = new String[v.size()];
        for (int i = 0; i < cmd.length; ++i) {
            cmd[i] = (String)v.elementAt(i);
        }
        return cmd;
    }

    public static String[] chop(String input, String str) {
        if (input == null || input.length() == 0 || input.trim().length() == 0) {
            return null;
        }
        int[] offsets = RegExpUtils.findFirstOccuranceOf(input, str, false, true);
        if (offsets == null) {
            return null;
        }
        Vector<String> out = new Vector<String>();
        while (offsets != null) {
            int begin = offsets[0];
            int end = offsets[1];
            out.addElement(input.substring(0, begin));
            input = input.substring(end);
            offsets = RegExpUtils.findFirstOccuranceOf(input, str, false, true);
        }
        return VectorUtils.toStringArray(out);
    }

    public static String[] tokenize(String input, String delim) {
        return TextUtils.tokenize(input, delim, false);
    }

    public static String[] tokenize(String input, String delim, boolean spaceIsValid) {
        int i;
        if (input == null || input.length() == 0 || input.trim().length() == 0) {
            return null;
        }
        if (spaceIsValid) {
            input = input.replaceAll("\\n", "\\n\u0010");
        }
        Vector<String> v = new Vector<String>();
        StringTokenizer t = new StringTokenizer(input, delim);
        while (t.hasMoreTokens()) {
            String str = t.nextToken();
            v.addElement(str);
        }
        Vector<String> tmp = new Vector<String>();
        for (i = 0; i < v.size(); ++i) {
            String item = (String)v.elementAt(i);
            if (!spaceIsValid) {
                item = item.trim();
            }
            if (spaceIsValid && item.length() == 0) {
                tmp.addElement(" ");
            }
            if (item == null || item.length() <= 0) continue;
            tmp.addElement(item);
        }
        String[] out = new String[tmp.size()];
        int n = 0;
        for (i = 0; i < tmp.size(); ++i) {
            String item = (String)tmp.elementAt(i);
            if (item == null || item.length() <= 0) continue;
            if (spaceIsValid) {
                item = input.replaceAll("\u0010", "\\n");
            }
            out[n++] = item;
        }
        return out;
    }

    public static int countOccurancesOf(String str, char c) {
        int num = 0;
        if (str == null) {
            return 0;
        }
        for (int n = 0; n < str.length(); ++n) {
            if (str.charAt(n) != c) continue;
            ++num;
        }
        return num;
    }

    public static int countOccurancesOf(Element element, char c) {
        Segment s = new Segment();
        try {
            element.getDocument().getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset(), s);
        }
        catch (BadLocationException e) {
            return 0;
        }
        return TextUtils.countOccurancesOf(s, c, '\u0000')[0];
    }

    public static int[] countOccurancesOf(Segment segment, char c) {
        return TextUtils.countOccurancesOf(segment, c, '\u0000');
    }

    public static int[] countOccurancesOf(DocumentEvent evt, char c) {
        Segment s = new Segment();
        int[] out = new int[]{0, 0, 0};
        try {
            evt.getDocument().getText(evt.getOffset(), evt.getLength(), s);
        }
        catch (BadLocationException e) {
            return null;
        }
        return TextUtils.countOccurancesOf(s, c, '\u0000');
    }

    public static int[] countOccurancesOf(Segment segment, char c, char terminator) {
        int[] out = new int[]{0, 0, 0};
        if (segment == null) {
            return out;
        }
        boolean foundFirst = false;
        for (int n = 0; n < segment.count; ++n) {
            if (segment.array[n + segment.offset] == terminator) {
                return out;
            }
            if (segment.array[n + segment.offset] != c) continue;
            if (!foundFirst) {
                out[1] = n;
                foundFirst = true;
            }
            out[0] = out[0] + 1;
            out[2] = n;
        }
        return out;
    }

    public static int countOccurancesOf(String src, String target) {
        int count = 0;
        String[] tokens = TextUtils.tokenize(src);
        for (int n = 0; n < tokens.length; ++n) {
            if (tokens[n].compareTo(target) != 0) continue;
            ++count;
        }
        return count;
    }

    public static String breakAtDelimitors(String input, String delim, int tabCount) {
        String[] lines = TextUtils.tokenize(input, delim);
        StringBuffer buf = new StringBuffer();
        StringBuffer tabs = new StringBuffer();
        for (int i = 0; i < tabCount; ++i) {
            tabs.append('\t');
        }
        if (lines == null) {
            return null;
        }
        for (int n = 0; n < lines.length; ++n) {
            buf.append(tabs + lines[n].trim() + '\n');
        }
        return buf.toString();
    }

    public static int countTabs(String str) {
        int result = 0;
        if (str == null) {
            return result;
        }
        for (int n = 0; n < str.length() && str.charAt(n) == '\t'; ++n) {
            ++result;
        }
        return result;
    }

    public static String breakAtWord(String input, String word) {
        StringBuffer out = new StringBuffer();
        Tokenizer tok = new Tokenizer();
        tok.setBuffer(input);
        int[] offset = tok.charSearch(word, true);
        if (offset == null) {
            return null;
        }
        out.append(input.substring(0, offset[0]) + "\n");
        out.append(input.substring(offset[0]) + "\n");
        return out.toString();
    }

    public static int length(String str) {
        StringBuffer buf = new StringBuffer(str);
        for (int n = 0; n < buf.length(); ++n) {
            Cutter.setLog("char [" + n + "] >" + buf.charAt(n) + "<");
        }
        return buf.length();
    }

    public static char[] addToCharArray(char[] dest, char[] src) {
        if (dest == null) {
            dest = new char[]{};
        }
        if (src != null) {
            int n;
            Vector<Character> list = new Vector<Character>();
            for (n = 0; n < dest.length; ++n) {
                list.addElement(Character.valueOf(dest[n]));
            }
            boolean doAdd = true;
            for (n = 0; n < src.length; ++n) {
                doAdd = true;
                for (int i = 0; i < list.size() && doAdd; ++i) {
                    if (src[n] != ((Character)list.elementAt(i)).charValue()) continue;
                    doAdd = false;
                }
                if (!doAdd) continue;
                list.addElement(Character.valueOf(src[n]));
            }
            dest = new char[list.size()];
            for (n = 0; n < dest.length; ++n) {
                dest[n] = ((Character)list.elementAt(n)).charValue();
            }
        }
        return dest;
    }

    public static String[] formatAsArray(String src, int width) {
        String str = TextUtils.format(src, width);
        if (str == null) {
            return null;
        }
        return TextUtils.tokenize(str, "\n");
    }

    public static String format(String src, int width) {
        return TextUtils.format(src, width, 75, null);
    }

    public static String format(String src, int width, int maxCount, String postScript) {
        if (src == null) {
            return null;
        }
        String[] words = TextUtils.tokenize(src.trim());
        StringBuffer tmp = new StringBuffer();
        boolean truncate = false;
        if (words == null || words.length == 0) {
            return null;
        }
        int count = words.length;
        if (words.length > maxCount) {
            count = maxCount;
            truncate = true;
        }
        for (int n = 0; n < count; ++n) {
            tmp.append(words[n] + " ");
        }
        src = tmp.toString();
        String[] item = TextUtils.tokenize(src);
        StringBuffer out = new StringBuffer();
        StringBuffer line = new StringBuffer();
        for (int n = 0; n < item.length; ++n) {
            if (item[n].trim().length() == 0) continue;
            if (RegExpUtils.contains(item[n], "<br>")) {
                out.append(line.toString().trim());
                out.append('\n');
                line.setLength(0);
                line.append(RegExpUtils.replaceAll(item[n], "<br>", "") + " ");
                continue;
            }
            if (line.length() + item[n].length() <= width) {
                line.append(item[n] + " ");
                continue;
            }
            out.append(line.toString().trim());
            out.append('\n');
            line.setLength(0);
            line.append(item[n] + " ");
        }
        if (line.length() > 0) {
            out.append(line.toString().trim());
        }
        if (out.length() > 0 && Character.isLowerCase(out.charAt(0))) {
            out.setCharAt(0, Character.toUpperCase(out.charAt(0)));
        }
        if (out.length() > 0 && out.charAt(out.length() - 1) != '.') {
            out.append('.');
        }
        if (truncate) {
            out.append("...\n");
        }
        if (truncate && postScript != null) {
            out.append(postScript);
        }
        return out.toString().trim();
    }

    public static String formatAsHtml(String src, int width, int maxCount) {
        if (src == null) {
            return null;
        }
        String[] words = TextUtils.tokenize(src.trim());
        StringBuffer tmp = new StringBuffer();
        boolean truncate = false;
        if (words == null || words.length == 0) {
            return null;
        }
        int count = words.length;
        if (words.length > maxCount) {
            count = maxCount;
            truncate = true;
        }
        for (int n = 0; n < count; ++n) {
            tmp.append(words[n] + " ");
        }
        src = tmp.toString();
        String[] tokens = TextUtils.tokenize(src);
        StringBuffer out = new StringBuffer();
        out.append("<html>");
        StringBuffer line = new StringBuffer();
        for (int n = 0; n < tokens.length; ++n) {
            if (tokens[n].trim().length() == 0) continue;
            if (line.length() + tokens[n].length() <= width) {
                line.append(tokens[n] + " ");
                continue;
            }
            out.append(line.toString().trim());
            out.append("<br>");
            line.setLength(0);
            line.append(tokens[n] + " ");
        }
        if (line.length() > 0) {
            out.append(line.toString().trim());
        }
        if (out.length() > 0 && Character.isLowerCase(out.charAt(0))) {
            out.setCharAt(0, Character.toUpperCase(out.charAt(0)));
        }
        if (out.length() > 0 && out.charAt(out.length() - 1) != '.') {
            out.append('.');
        }
        if (truncate) {
            out.append("...<br>");
        }
        out.append("</html>");
        return out.toString().trim();
    }

    public static String abbreviate(String src, int lngth) {
        lngth = src.length() < lngth ? src.length() : lngth;
        return src.substring(0, lngth);
    }

    public static char[] removeFromCharArray(char[] dest, char[] src) {
        int n;
        if (dest == null) {
            return null;
        }
        if (src == null) {
            return dest;
        }
        Vector<Character> list = new Vector<Character>();
        boolean doAdd = true;
        for (n = 0; n < dest.length; ++n) {
            doAdd = true;
            for (int i = 0; i < src.length && doAdd; ++i) {
                if (dest[n] != src[i]) continue;
                doAdd = false;
            }
            if (!doAdd) continue;
            list.addElement(Character.valueOf(dest[n]));
        }
        dest = new char[list.size()];
        for (n = 0; n < dest.length; ++n) {
            dest[n] = ((Character)list.elementAt(n)).charValue();
        }
        return dest;
    }

    public static String toAsciRepresentation(String src) {
        StringBuffer out = new StringBuffer();
        for (int n = 0; n < src.length(); ++n) {
            out.append(src.charAt(n) + " ");
        }
        return out.toString();
    }

    public static boolean hasText(String src) {
        for (int n = 0; n < src.length(); ++n) {
            if (src.charAt(n) <= ' ') continue;
            return true;
        }
        return false;
    }

    public static boolean hasText(char[] src) {
        for (int n = 0; n < src.length; ++n) {
            if (src[n] <= ' ') continue;
            return true;
        }
        return false;
    }

    public static String addEscapesTo(String str, char[] ch) {
        StringBuffer buf = new StringBuffer();
        char prev = '\u0000';
        boolean found = false;
        for (int n = 0; n < str.length(); ++n) {
            found = false;
            for (int i = 0; i < ch.length; ++i) {
                if (str.charAt(n) == ch[i] && prev != '\\') {
                    buf.append('\\');
                    buf.append(ch[i]);
                    found = true;
                    continue;
                }
                if (str.charAt(n) == ch[i] && prev == '\\') {
                    buf.append(str.charAt(n));
                    found = true;
                    continue;
                }
                found = false;
            }
            if (!found) {
                buf.append(str.charAt(n));
            }
            prev = str.charAt(n);
        }
        return buf.toString();
    }

    public static void removeEscapes(String str) {
    }

    public static String[] vectorToArray(Vector v) {
        String[] out = new String[v.size()];
        for (int n = 0; n < v.size(); ++n) {
            out[n] = (String)v.elementAt(n);
        }
        return out;
    }

    public static String stringArrayToString(String[] lines) {
        StringBuffer out = new StringBuffer();
        for (int n = 0; n < lines.length; ++n) {
            out.append(lines[n]).append("\n");
        }
        return out.toString();
    }

    public static String[] alphaSort(String[] unsorted) {
        int n;
        Collator collator = Collator.getInstance(Locale.ENGLISH);
        String[] sorted = new String[unsorted.length];
        for (n = 0; n < unsorted.length; ++n) {
            sorted[n] = unsorted[n];
        }
        for (n = 0; n < sorted.length; ++n) {
            for (int i = n + 1; i < sorted.length; ++i) {
                String currStr = sorted[n];
                String nextStr = sorted[i];
                if (collator.compare(currStr, nextStr) <= 0) continue;
                String nTmp = currStr;
                String iTmp = nextStr;
                sorted[i] = nTmp;
                sorted[n] = iTmp;
            }
        }
        return sorted;
    }

    public static String capitalize(String src) {
        char c = src.charAt(0);
        return Character.toUpperCase(c) + src.substring(1);
    }

    public static boolean isAllUpperCase(String src) {
        if (src == null || src.trim().length() == 0) {
            return false;
        }
        for (int n = 0; n < src.length(); ++n) {
            if (!Character.isLowerCase(src.charAt(n))) continue;
            return false;
        }
        return true;
    }

    public static String removeTabs(String src, int count) {
        if (count <= 0) {
            return src;
        }
        String[] lines = TextUtils.tokenize(src, '\n');
        if (lines == null || lines.length == 0) {
            return src;
        }
        StringBuffer buf = new StringBuffer();
        for (int n = 0; n < lines.length; ++n) {
            int leadingSpaces = 0;
            int leadingTabs = 0;
            String line = lines[n];
            for (int j = 0; j < line.length() && !Character.isLetterOrDigit(line.charAt(j)) && line.charAt(j) != '#'; ++j) {
                if (line.charAt(j) == ' ') {
                    ++leadingSpaces;
                    continue;
                }
                if (line.charAt(j) != '\t') continue;
                ++leadingTabs;
            }
            line = line.trim();
            int proxyTabs = 0;
            if (leadingSpaces >= 4) {
                proxyTabs = leadingSpaces / 4;
                leadingSpaces -= proxyTabs * 4;
            }
            leadingTabs += proxyTabs;
            leadingTabs = (leadingTabs -= count) < 0 ? 0 : leadingTabs;
            StringBuffer tabBuf = new StringBuffer();
            for (int k = 0; k < leadingTabs; ++k) {
                tabBuf.append("\t");
            }
            StringBuffer spaceBuf = new StringBuffer();
            for (int k = 0; k < leadingSpaces; ++k) {
                spaceBuf.append(" ");
            }
            buf.append(tabBuf.toString()).append(spaceBuf.toString()).append(line).append("\n");
        }
        return buf.toString();
    }
}

