/*
 * Decompiled with CFR 0.152.
 */
package Utilities;

import UI_Desktop.Cutter;
import Utilities.Point3D;
import Utilities.TextUtils;

public class TransformUtils {
    public static double[] aimZ(Point3D from, Point3D to) {
        Point3D vec = TransformUtils.getDirectionVector(from, to);
        if (Math.abs(vec.x) < 1.0E-8 && Math.abs(vec.y) < 1.0E-8 && Math.abs(vec.z) < 1.0E-8) {
            return null;
        }
        double vecLength = Math.sqrt(vec.x * vec.x + vec.y * vec.y + vec.z * vec.z);
        double[] out = new double[]{0.0, 0.0, vecLength};
        if (vec.x == 0.0 && vec.y == 0.0) {
            if (vec.z < 0.0) {
                out[1] = 180.0;
            }
            return out;
        }
        double xzLength = Math.sqrt(vec.x * vec.x + vec.z * vec.z);
        if (xzLength == 0.0) {
            out[0] = vec.y > 0.0 ? -90.0 : 90.0;
            out[1] = 0.0;
            out[2] = vecLength;
            return out;
        }
        double xAngle = 180.0 * Math.acos(xzLength / vecLength) / Math.PI;
        double yAngle = 180.0 * Math.acos(vec.z / xzLength) / Math.PI;
        if (vec.y > 0.0) {
            xAngle *= -1.0;
        }
        if (vec.x < 0.0) {
            yAngle *= -1.0;
        }
        out[0] = xAngle;
        out[1] = yAngle;
        out[2] = vecLength;
        return out;
    }

    public static Point3D getDirectionVector(Point3D from, Point3D to) {
        Point3D vec = new Point3D();
        vec.x = from.x - to.x;
        vec.y = from.y - to.y;
        vec.z = from.z - to.z;
        return vec;
    }

    public static Point3D toPoint3D(String xStr, String yStr, String zStr) {
        Point3D pnt = new Point3D();
        try {
            pnt.x = Double.valueOf(xStr);
            pnt.y = Double.valueOf(yStr);
            pnt.z = Double.valueOf(zStr);
        }
        catch (Exception e) {
            Cutter.setLog("    Error: TransformUtils.toPoint3D() " + e.toString());
            return null;
        }
        return pnt;
    }

    public static String[] reformatTransformMatrix(String valstr) {
        int n;
        int n2;
        String[] vals;
        int comIndex = valstr.indexOf("#");
        valstr = comIndex == -1 ? valstr : valstr.substring(0, comIndex);
        if ((valstr = valstr.trim()).startsWith("[")) {
            valstr = valstr.substring(1);
        }
        if (valstr.endsWith("]")) {
            valstr = valstr.substring(0, valstr.length() - 1);
        }
        if ((vals = TextUtils.tokenize(valstr)) == null || vals.length != 16) {
            return null;
        }
        boolean pad = false;
        try {
            for (n2 = 0; n2 < 16; ++n2) {
                if (Math.abs(Double.parseDouble(vals[n2])) < 1.0E-5) {
                    vals[n2] = "0";
                }
                if (!vals[n2].startsWith("-")) continue;
                pad = true;
            }
        }
        catch (NumberFormatException ex) {
            Cutter.setLog("    Exception:TransformUtils.reformat() " + ex.toString());
        }
        if (pad) {
            for (n2 = 0; n2 < 16; ++n2) {
                if (vals[n2].startsWith("-")) continue;
                vals[n2] = " " + vals[n2];
            }
        }
        int maxwidth = 0;
        for (n = 0; n < 16; ++n) {
            if (vals[n].length() <= maxwidth) continue;
            maxwidth = vals[n].length();
        }
        for (n = 0; n < 15; ++n) {
            int diff = maxwidth - vals[n].length();
            vals[n] = vals[n] + TransformUtils.postpad(diff);
        }
        String[] out = new String[6];
        out[0] = pad ? " [" : "[";
        StringBuffer buf = new StringBuffer();
        buf.append(vals[0]).append(" ").append(vals[1]).append(" ").append(vals[2]).append(" ").append(vals[3]);
        out[1] = buf.toString();
        buf.delete(0, buf.length());
        buf.append(vals[4]).append(" ").append(vals[5]).append(" ").append(vals[6]).append(" ").append(vals[7]);
        out[2] = buf.toString();
        buf.delete(0, buf.length());
        buf.append(vals[8]).append(" ").append(vals[9]).append(" ").append(vals[10]).append(" ").append(vals[11]);
        out[3] = buf.toString();
        buf.delete(0, buf.length());
        buf.append(vals[12]).append(" ").append(vals[13]).append(" ").append(vals[14]).append(" ").append(vals[15]);
        out[4] = buf.toString();
        out[5] = pad ? " ]" : "]";
        return out;
    }

    private static String postpad(int num) {
        if (num <= 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (int j = 0; j < num; ++j) {
            buf.append(" ");
        }
        return buf.toString();
    }
}

