/*
 * Decompiled with CFR 0.152.
 */
package Utilities;

import Utilities.MatrixN;

class VectorN {
    private double[] v;

    VectorN(int n) {
        this.v = new double[n];
    }

    int size() {
        return this.v.length;
    }

    double get(int j) {
        return this.v[j];
    }

    void set(int j, double f) {
        this.v[j] = f;
    }

    void set(VectorN vec) {
        for (int j = 0; j < this.size(); ++j) {
            this.set(j, vec.get(j));
        }
    }

    public String toString() {
        String s = "";
        for (int j = 0; j < this.size(); ++j) {
            s = s + (j == 0 ? "" : " ") + this.get(j);
        }
        return s + "";
    }

    void transform(MatrixN mat) {
        VectorN tmp = new VectorN(this.size());
        for (int i = 0; i < this.size(); ++i) {
            double f = 0.0;
            for (int j = 0; j < this.size(); ++j) {
                f += mat.get(i, j) * this.get(j);
            }
            tmp.set(i, f);
        }
        this.set(tmp);
    }

    double distance(VectorN vec) {
        double d = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            double x = vec.get(0) - this.get(0);
            double y = vec.get(1) - this.get(1);
            d += x * x + y * y;
        }
        return Math.sqrt(d);
    }
}

