/*
 * Decompiled with CFR 0.152.
 */
package Utilities;

import Utilities.HashTableUtils;
import Utilities.TextUtils;
import java.awt.Component;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;

public class VectorUtils {
    public static boolean contains(Vector<String> listOfNames, String name) {
        if (listOfNames == null || listOfNames.size() == 0) {
            return false;
        }
        for (int n = 0; n < listOfNames.size(); ++n) {
            if (!listOfNames.elementAt(n).equals(name)) continue;
            return true;
        }
        return false;
    }

    public static Vector<String> combine(Vector<String> head, Vector<String> tail) {
        int n;
        if (head == null || head.size() == 0) {
            return tail;
        }
        if (tail == null || tail.size() == 0) {
            return head;
        }
        Vector<String> out = new Vector<String>();
        for (n = 0; n < head.size(); ++n) {
            out.addElement(head.elementAt(n));
        }
        for (n = 0; n < tail.size(); ++n) {
            out.addElement(tail.elementAt(n));
        }
        return out;
    }

    public static String[] uniquefy(String[] flags) {
        Vector<String> input = VectorUtils.toVector(flags);
        Vector<String> output = VectorUtils.uniquefy(input);
        return VectorUtils.toStringArray(output);
    }

    public static Vector<String> uniquefy(Vector<String> vector) {
        Hashtable<String, String> table = new Hashtable<String, String>();
        for (int n = 0; n < vector.size(); ++n) {
            String s = vector.elementAt(n);
            if (s == null) continue;
            table.put(s.trim(), s.trim());
        }
        String[] strs = HashTableUtils.getAllStringValues(table);
        return VectorUtils.toVector(strs);
    }

    public static String[] consolidatAsFlags(String input) {
        StringBuffer b;
        if (input == null || input.trim().length() == 0) {
            return null;
        }
        Vector<StringBuffer> v = new Vector<StringBuffer>();
        String[] rawflags = TextUtils.tokenize(input);
        for (int n = 0; n < rawflags.length; ++n) {
            String token = rawflags[n];
            if (token.startsWith("-")) {
                b = new StringBuffer();
                b.append(token).append(" ");
                v.addElement(b);
                continue;
            }
            int lastIndex = v.size() - 1;
            if (lastIndex < 0) continue;
            StringBuffer b2 = (StringBuffer)v.remove(lastIndex);
            b2.append(token);
            v.addElement(b2);
        }
        String[] outFlags = new String[v.size()];
        for (int n = 0; n < v.size(); ++n) {
            b = (StringBuffer)v.elementAt(n);
            outFlags[n] = b.toString().trim();
        }
        return VectorUtils.uniquefy(outFlags);
    }

    public static Vector<File> copyFiles(Vector<File> v) {
        if (v == null) {
            return null;
        }
        Vector<File> out = new Vector<File>();
        for (int n = 0; n < v.size(); ++n) {
            out.addElement(v.elementAt(n));
        }
        return out;
    }

    public static Vector<String> copyStrings(Vector<String> v) {
        if (v == null) {
            return null;
        }
        Vector<String> out = new Vector<String>();
        for (int n = 0; n < v.size(); ++n) {
            out.addElement(v.elementAt(n));
        }
        return out;
    }

    public static String vectorToSpacedString(Vector<String> v) {
        if (v == null || v.size() == 0) {
            return "";
        }
        StringBuffer buff = new StringBuffer();
        for (int n = 0; n < v.size(); ++n) {
            buff.append(v.elementAt(n) + " ");
        }
        return buff.toString().trim();
    }

    public static String arrayToSpacedString(String[] strs) {
        if (strs == null || strs.length == 0) {
            return "";
        }
        StringBuffer buff = new StringBuffer();
        for (int n = 0; n < strs.length; ++n) {
            buff.append(strs[n] + " ");
        }
        return buff.toString().trim();
    }

    public static String[] spacedStringToArray(String str) {
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        return TextUtils.tokenize(str);
    }

    public static Vector<String> spacedStringToVector(String str) {
        if (str == null || str.trim().length() == 0) {
            return new Vector<String>();
        }
        String[] items = VectorUtils.spacedStringToArray(str);
        Vector v = VectorUtils.toVector(items);
        return v == null ? new Vector() : v;
    }

    public static Vector<String> toVector(String[] items) {
        if (items == null || items.length == 0) {
            return null;
        }
        Vector<String> v = new Vector<String>(items.length);
        for (int n = 0; n < items.length; ++n) {
            v.addElement(items[n]);
        }
        return v;
    }

    public static String toSpacedString(Vector v) {
        if (v == null || v.size() == 0) {
            return "";
        }
        String[] arr = VectorUtils.toStringArray(v);
        if (arr == null || arr.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int n = 0; n < arr.length; ++n) {
            sb.append(arr[n]).append(" ");
        }
        return sb.toString().trim();
    }

    public static String[] toStringArray(Vector v) {
        if (v == null || v.size() == 0) {
            return null;
        }
        String[] out = new String[v.size()];
        for (int n = 0; n < v.size(); ++n) {
            out[n] = (String)v.elementAt(n);
        }
        return out;
    }

    public static String[] toStringArray(String[] array1, String[] array2) {
        int n;
        Vector<String> all = new Vector<String>();
        if (array1 != null) {
            for (n = 0; n < array1.length; ++n) {
                all.addElement(array1[n]);
            }
        }
        if (array2 != null) {
            for (n = 0; n < array2.length; ++n) {
                all.addElement(array2[n]);
            }
        }
        return VectorUtils.toStringArray(all);
    }

    public static String[] toStringArray(String[] array1, String str) {
        Vector<String> all = new Vector<String>();
        if (array1 != null) {
            for (int n = 0; n < array1.length; ++n) {
                all.addElement(array1[n]);
            }
        }
        if (str != null) {
            all.addElement(str);
        }
        return VectorUtils.toStringArray(all);
    }

    public static String[] toStringArray(String str, String[] array) {
        Vector<String> all = new Vector<String>();
        if (str != null) {
            all.addElement(str);
        }
        if (array != null) {
            for (int n = 0; n < array.length; ++n) {
                all.addElement(array[n]);
            }
        }
        return VectorUtils.toStringArray(all);
    }

    public static char[] addToCharArray(char c, char[] array) {
        char[] tmp = new char[array.length + 1];
        for (int n = 0; n < array.length; ++n) {
            tmp[n] = array[n];
        }
        tmp[n] = c;
        return tmp;
    }

    public static File[] toFileArray(Vector v) {
        if (v == null || v.size() == 0) {
            return null;
        }
        File[] out = new File[v.size()];
        for (int n = 0; n < v.size(); ++n) {
            out[n] = (File)v.elementAt(n);
        }
        return out;
    }

    public static Component[] toComponentArray(Vector v) {
        if (v == null || v.size() == 0) {
            return null;
        }
        Component[] out = new Component[v.size()];
        for (int n = 0; n < v.size(); ++n) {
            out[n] = (Component)v.elementAt(n);
        }
        return out;
    }

    public static String stringArrayToText(String[] input) {
        if (input == null || input.length == 0) {
            return "";
        }
        StringBuffer buff = new StringBuffer();
        for (int n = 0; n < input.length; ++n) {
            buff.append(input[n]).append("\n");
        }
        return buff.toString();
    }

    public static String commaToSpaceSeparated(String input, String prefix) {
        if (input == null || input.trim().length() == 0) {
            return null;
        }
        String[] tokens = TextUtils.tokenize(input, ",");
        StringBuffer out = new StringBuffer();
        if (prefix == null || prefix.trim().length() == 0) {
            prefix = "";
        }
        for (int n = 0; n < tokens.length; ++n) {
            out.append(prefix).append(tokens[n]).append(" ");
        }
        return out.toString().trim();
    }
}

