/*
 * Decompiled with CFR 0.152.
 */
package Utilities;

import UI_Desktop.Cutter;
import Utilities.TextUtils;
import Utilities.VectorUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipUtils {
    public static int copy(File src, File dest) {
        if (src == null || !src.exists()) {
            return -1;
        }
        ZipOutputStream destZipStream = null;
        ZipFile srcZipFile = null;
        Vector<ZipEntry> listOfEntries = new Vector<ZipEntry>();
        try {
            FileOutputStream destStream = new FileOutputStream(dest);
            destZipStream = new ZipOutputStream(destStream);
            srcZipFile = new ZipFile(src);
            Enumeration<? extends ZipEntry> e = srcZipFile.entries();
            while (e.hasMoreElements()) {
                ZipEntry ze = e.nextElement();
                listOfEntries.addElement(ze);
            }
            byte[] data = new byte[1024];
            for (int n = 0; n < listOfEntries.size(); ++n) {
                int len;
                ZipEntry ze = (ZipEntry)listOfEntries.elementAt(n);
                InputStream in = srcZipFile.getInputStream(ze);
                destZipStream.putNextEntry(ze);
                while ((len = in.read(data)) >= 0) {
                    destZipStream.write(data, 0, len);
                }
                in.close();
            }
            srcZipFile.close();
            destStream.close();
        }
        catch (IOException e) {
            Cutter.setLog("    Exception: ZipUtils.copy():");
            Cutter.setLog(e.toString());
            return -1;
        }
        return listOfEntries.size();
    }

    public static ZipEntry getFirstZipEntry(File zipfile) {
        ZipEntry zipentry;
        try {
            FileInputStream stream = new FileInputStream(zipfile);
            ZipInputStream in = new ZipInputStream(stream);
            zipentry = in.getNextEntry();
            in.closeEntry();
            in.close();
            stream.close();
        }
        catch (Exception e) {
            Cutter.setLog("    Exception:ZipUtils.getFirstZipEntry() " + e);
            return null;
        }
        return zipentry;
    }

    public static String[] getAllZipEntries(File zipfile) {
        Vector<String> vector = new Vector<String>();
        try {
            ZipEntry zipentry;
            FileInputStream stream = new FileInputStream(zipfile);
            ZipInputStream in = new ZipInputStream(stream);
            while ((zipentry = in.getNextEntry()) != null) {
                String tail = zipentry.getName();
                String[] subs = ZipUtils.getSubFilesOf(new File(tail));
                for (int n = 0; n < subs.length; ++n) {
                    if (vector.contains(subs[n])) continue;
                    vector.addElement(subs[n]);
                }
                in.closeEntry();
            }
            in.close();
            stream.close();
        }
        catch (Exception e) {
            Cutter.setLog("Exception in ZipUtils.getAllZipEntries()\n" + e.toString());
            return null;
        }
        return VectorUtils.toStringArray(vector);
    }

    public static boolean saveZipEntryToFile(ZipInputStream zipEntryStream, File head, File tail) {
        if (!head.exists()) {
            head.mkdir();
        }
        byte[] buffer = new byte[2048];
        try {
            int read;
            File outfile = tail != null ? new File(head, tail.getPath()) : head;
            FileOutputStream outstream = new FileOutputStream(outfile);
            while ((read = zipEntryStream.read(buffer, 0, buffer.length)) > 0) {
                outstream.write(buffer, 0, read);
            }
            outstream.close();
        }
        catch (IOException e) {
            Cutter.setLog("    Exception:ZipUtils.saveZipEntryToFile()\n" + e);
            return false;
        }
        return true;
    }

    private static String[] getSubFilesOf(File file) {
        String path = file.getPath();
        Vector<String> listOfSubs = new Vector<String>();
        StringTokenizer tok = new StringTokenizer(file.getPath(), "" + File.separatorChar);
        Vector<String> subDir = new Vector<String>();
        while (tok.hasMoreTokens()) {
            subDir.addElement(tok.nextToken());
        }
        String subPath = "";
        for (int n = 0; n < subDir.size(); ++n) {
            subPath = subPath.length() == 0 ? (String)subDir.elementAt(n) : subPath + File.separatorChar + (String)subDir.elementAt(n);
            listOfSubs.addElement(subPath);
        }
        return VectorUtils.toStringArray(listOfSubs);
    }

    public static boolean saveTextHistoryToZip(File file, byte[][] data, String[] time) {
        String zippath = TextUtils.removeExtension(file.getPath()) + ".zip";
        File outfile = new File(zippath);
        try {
            FileOutputStream filestream = new FileOutputStream(outfile);
            ZipOutputStream zipstream = new ZipOutputStream(filestream);
            zipstream.setComment("History for " + file.getPath());
            for (int n = 0; n < data.length; ++n) {
                ZipEntry zipentry = new ZipEntry(time[n]);
                zipstream.putNextEntry(zipentry);
                zipstream.write(data[n], 0, data[n].length);
                zipstream.closeEntry();
            }
            zipstream.close();
            filestream.close();
        }
        catch (IOException e) {
            Cutter.setLog("    Error: ZipUtils.saveTextHistoryToZip() " + e.toString());
            return false;
        }
        return true;
    }
}

