/*
 * Decompiled with CFR 0.152.
 */
package kernal.Searchers;

import UI_Desktop.Cutter;
import UI_Script.Html.HtmlTokenizer;
import Utilities.FileUtils;
import Utilities.TextUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import kernal.Searchers.SearchResult;
import kernal.Tokenizers.Tokenizer;

public class HTMLSearch {
    protected String[] arrayOfTargetPaths = new String[0];
    public String INDEX_PAGE = "";
    protected HtmlTokenizer tok = null;
    protected Tokenizer searcher = new Tokenizer();
    protected String target = null;
    protected String bestHit = "no matches";
    protected int listIndex;
    protected Vector<SearchResult> listOfResults = new Vector();
    protected JProgressBar progressBar = null;
    protected String searchPath = null;
    static boolean printOne = true;

    public HTMLSearch(String searchPath) {
        this(searchPath, null);
    }

    public HTMLSearch(String searchPath, JProgressBar bar) {
        this.progressBar = bar;
        this.searchPath = searchPath;
        if (this.progressBar != null) {
            this.progressBar.setMinimum(0);
            this.progressBar.setMaximum(this.arrayOfTargetPaths.length);
        }
    }

    public String[] getTargetPaths() {
        return this.getTargetPaths(1);
    }

    public String[] getTargetPaths(int recursionDepth) {
        if (this.searchPath == null) {
            return null;
        }
        if (HtmlTokenizer.isHTTP(this.searchPath)) {
            try {
                URL url = new URL(this.searchPath + "/" + this.INDEX_PAGE);
                Cutter.setLog("HTMLSearch.getTargetPaths() url = " + url.toString());
                this.arrayOfTargetPaths = this.getTargetsFromURL(url);
            }
            catch (MalformedURLException ex) {
                Cutter.setLog("    Exception: HTMLSeach.getTargetPaths() searchPath = >" + this.searchPath + "<");
                Cutter.setLog("    Exception: HTMLSeach.getTargetPaths() " + ex.toString());
                return null;
            }
        } else {
            this.arrayOfTargetPaths = this.getTargetsFromDirectory(recursionDepth);
        }
        return this.arrayOfTargetPaths;
    }

    protected String[] getTargetsFromDirectory(int maxdepth) {
        FileUtils utils = new FileUtils();
        utils.setSearch(maxdepth, new File(this.searchPath), ".html");
        utils.doSearch();
        this.arrayOfTargetPaths = utils.getSearchResults();
        Vector<String> v = new Vector<String>();
        if (this.arrayOfTargetPaths != null) {
            for (int n = 0; n < this.arrayOfTargetPaths.length; ++n) {
                v.addElement(this.arrayOfTargetPaths[n]);
            }
        }
        utils = new FileUtils();
        utils.setSearch(maxdepth, new File(this.searchPath), ".htm");
        utils.doSearch();
        String[] l = utils.getSearchResults();
        if (l != null) {
            for (int n = 0; n < l.length; ++n) {
                v.addElement(l[n]);
            }
        }
        this.arrayOfTargetPaths = TextUtils.vectorToArray(v);
        if (this.progressBar != null) {
            this.progressBar.setMaximum(this.arrayOfTargetPaths.length);
        }
        return this.arrayOfTargetPaths;
    }

    protected String[] getTargetsFromURL(URL url) {
        Vector<String> vector = new Vector<String>();
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            while ((line = in.readLine()) != null) {
                String[] tokens = TextUtils.tokenize(line, "\"");
                if (tokens == null) continue;
                for (int n = 0; n < tokens.length; ++n) {
                    if (!tokens[n].endsWith(".html")) continue;
                    vector.addElement(tokens[n]);
                }
            }
            in.close();
        }
        catch (IOException ex) {
            Cutter.setLog("    Exception: HTMLSearch.getTargetPathsFrom(URL) " + ex.toString());
            this.arrayOfTargetPaths = null;
            return null;
        }
        this.arrayOfTargetPaths = TextUtils.vectorToArray(vector);
        return this.arrayOfTargetPaths;
    }

    public Vector find(String target, int sortSize, boolean ignoreCase, boolean wholeWord) {
        return this.find(target, sortSize, ignoreCase, wholeWord, null, null);
    }

    public Vector find(String target, int sortSize, boolean ignoreCase, boolean wholeWord, String from, String to) {
        this.listOfResults.removeAllElements();
        if (target == null || target.length() == 0) {
            return null;
        }
        if (this.arrayOfTargetPaths == null && this.getTargetPaths() == null) {
            Cutter.setLog("HTMLSearch.find() no html/htm files in >" + this.searchPath + "<");
            return null;
        }
        this.target = target;
        if (this.progressBar != null) {
            this.progressBar.setMaximum(this.arrayOfTargetPaths.length);
        }
        int maxHits = 0;
        int count = 0;
        int indexOfBestHit = -1;
        StringBuffer path = new StringBuffer();
        this.listIndex = 0;
        while (this.listIndex < this.arrayOfTargetPaths.length) {
            path.setLength(0);
            path.append(this.searchPath);
            if (!path.toString().endsWith("/")) {
                path.append("/");
            }
            path.append(this.arrayOfTargetPaths[this.listIndex]);
            this.tok = HtmlTokenizer.getHtmlTokenizerFor(path.toString());
            if (this.tok == null) {
                Cutter.setLog("HTMLSearch.find() cannot get tokenizer for " + path.toString());
            } else {
                String text = this.tok.getBodyText();
                if (text != null) {
                    if (!this.setProgress(this.listIndex)) {
                        return null;
                    }
                    int hits = this.countOccurances(text, ignoreCase, wholeWord);
                    if (hits > 0) {
                        ++count;
                        this.listOfResults.addElement(new SearchResult(this.arrayOfTargetPaths[this.listIndex], hits));
                    }
                    if (hits > maxHits) {
                        maxHits = hits;
                        this.bestHit = this.arrayOfTargetPaths[this.listIndex];
                        indexOfBestHit = this.listIndex;
                    }
                }
            }
            ++this.listIndex;
        }
        if (!this.setProgress(0)) {
            return null;
        }
        if (indexOfBestHit == -1) {
            return null;
        }
        Vector<SearchResult> out = new Vector<SearchResult>();
        out.addElement(new SearchResult(this.bestHit, maxHits));
        int max = maxHits - 1;
        while (out.size() <= sortSize) {
            for (int i = 0; i < this.listOfResults.size(); ++i) {
                if (out.size() > sortSize) {
                    return out;
                }
                if (this.listOfResults.elementAt((int)i).hits != max) continue;
                out.addElement(this.listOfResults.elementAt(i));
            }
            if (--max > 0) continue;
            return out;
        }
        if (out.size() == 0) {
            return null;
        }
        return out;
    }

    protected int countOccurances(String source, boolean ignoreCase, boolean wholeWord) {
        this.searcher.setBuffer(source);
        int[] offset = this.searcher.searchFor(this.target, ignoreCase, wholeWord);
        if (offset == null) {
            return 0;
        }
        int begin = offset[1];
        int length = source.length();
        int counter = 1;
        while (begin < length) {
            this.searcher.setBufferIndex(begin);
            offset = this.searcher.searchFor(this.target, ignoreCase, wholeWord);
            if (offset == null) {
                return counter;
            }
            begin = offset[1];
            ++counter;
        }
        return counter;
    }

    protected boolean setProgress(final int val) {
        if (val % 2 != 0) {
            return true;
        }
        if (this.progressBar == null) {
            return true;
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    HTMLSearch.this.progressBar.setValue(val);
                }
            });
        }
        catch (Exception ex) {
            Cutter.setLog("HTMLSearch.find exception" + ex.toString());
            return false;
        }
        return true;
    }

    public String[] getDocsBeginningWith(String prefix) {
        String[] list = this.getTargetPaths();
        return this.cull(list, prefix);
    }

    protected String[] cull(String[] input, String prefix) {
        if (input == null || prefix == null) {
            return null;
        }
        Vector<String> temp = new Vector<String>();
        for (int n = 0; n < input.length; ++n) {
            String item = TextUtils.removeExtension(input[n]);
            if (!item.regionMatches(0, prefix, 0, prefix.length())) continue;
            temp.addElement(input[n]);
        }
        return TextUtils.vectorToArray(temp);
    }
}

