/*
 * Decompiled with CFR 0.152.
 */
package kernal.Tokenizers;

import UI_Desktop.Cutter;
import Utilities.TextUtils;
import kernal.Tokenizers.Tokenizer;

public class FindReplaceTokenizer
extends Tokenizer {
    private StringBuffer peekStrBuffer = new StringBuffer(128);

    @Override
    public int[] searchFor(String pattern, boolean ignoreCase, boolean wholeWord) {
        if (wholeWord) {
            return this.stringSearch(pattern, ignoreCase);
        }
        return this.charSearch(pattern, ignoreCase);
    }

    @Override
    public int[] stringSearch(String pattern, boolean ignoreCase) {
        int[] out = new int[2];
        char[] ar = TextUtils.contains(pattern, "\n\t :;,.[]{}<>()");
        this.setDelimitor("\n\t :;,.[]{}<>()");
        if (ar != null) {
            this.removeDelimitor(new String(ar));
        }
        String str = this.getNextStr();
        while (!this.mEndOfBuffer) {
            if (ignoreCase && pattern.equalsIgnoreCase(str) || !ignoreCase && pattern.equals(str)) {
                int rewind = this.isDelimitor(this.peekPrevChar()) ? pattern.length() + 1 : pattern.length();
                for (int i = 0; i < rewind; ++i) {
                    this.ungetChar();
                }
                out[0] = this.getBufferIndex();
                out[1] = out[0] + str.length();
                return out;
            }
            str = this.getNextStr();
        }
        if (str.length() > 0 && (ignoreCase && pattern.equalsIgnoreCase(str) || !ignoreCase && pattern.equals(str))) {
            int rewind = this.isDelimitor(this.peekPrevChar()) ? pattern.length() + 1 : pattern.length();
            for (int i = 0; i < rewind; ++i) {
                this.ungetChar();
            }
            out[0] = this.getBufferIndex();
            out[1] = out[0] + str.length();
            return out;
        }
        return null;
    }

    @Override
    public int[] charSearch(String pattern, boolean ignoreCase) {
        if (pattern == null || pattern.length() == 0) {
            return null;
        }
        char c = this.readChar();
        char p = pattern.charAt(0);
        char[] peekChars = null;
        int[] out = new int[2];
        int peekLength = pattern.length() - 1;
        int patternLength = pattern.length();
        if (this.mEndOfBuffer) {
            return null;
        }
        while (!this.mEndOfBuffer) {
            if (!ignoreCase && c == p || ignoreCase && Character.toLowerCase(c) == Character.toLowerCase(p)) {
                peekChars = this.peekNextChars(peekLength);
                if (peekChars == null) {
                    return null;
                }
                this.peekStrBuffer.setLength(0);
                this.peekStrBuffer.append(c).append(peekChars);
                if (!ignoreCase && pattern.equals(this.peekStrBuffer.toString()) || ignoreCase && pattern.equalsIgnoreCase(this.peekStrBuffer.toString())) {
                    out[0] = this.getBufferIndex() - 1;
                    out[1] = out[0] + patternLength;
                    return out;
                }
            }
            c = this.readChar();
        }
        if (patternLength > 1) {
            return null;
        }
        if (!ignoreCase && c == p || ignoreCase && Character.toLowerCase(c) == Character.toLowerCase(p)) {
            out[0] = this.getBufferIndex() - 1;
            out[1] = out[0] + patternLength;
            return out;
        }
        return null;
    }

    @Override
    public String getNextStr() {
        this.outBuff.setLength(0);
        char c = this.readChar();
        while (!this.mEndOfBuffer && this.isDelimitor(c)) {
            if (this.getNextStr_return_delimitor) {
                return "" + c;
            }
            c = this.readChar();
        }
        while (!this.mEndOfBuffer) {
            this.outBuff.append(c);
            c = this.readChar();
            if (!this.isDelimitor(c)) continue;
            if (!this.getNextStr_return_delimitor) {
                this.ungetChar();
                return this.outBuff.toString();
            }
            return this.outBuff.toString();
        }
        return this.outBuff.toString();
    }

    public String replaceAll(String str, String replacement, boolean ignoreCase, boolean wholeWord) {
        if (str == null) {
            return null;
        }
        int[] offset = this.searchFor(str, ignoreCase, wholeWord);
        if (offset == null) {
            return null;
        }
        Cutter.setLog(new String(this.getBuffer()) + "  begin >" + offset[0] + "<  end >" + offset[1]);
        int strlen = str.length();
        int replen = replacement.length();
        StringBuffer out = new StringBuffer(this.getBufferLength());
        for (int begin = offset[0]; begin < strlen; begin += offset[0]) {
            Cutter.setLog("replaceAll begin = " + begin);
            out.append(this.getBuffer(0, begin));
            this.setBufferIndex(begin += replen);
            offset = this.searchFor(str, ignoreCase, wholeWord);
            if (offset != null) continue;
            return out.toString();
        }
        return out.toString();
    }
}

