/*
 * Decompiled with CFR 0.152.
 */
package kernal.Tokenizers;

import UI_Desktop.Cutter;
import UI_Desktop.KDesktop;
import UI_Script.Comment;
import UI_Script.Escape;
import UI_Script.Quotation;
import UI_Script.ScriptParser.ProcDBItem;
import Utilities.NumberUtils;
import Utilities.SegmentUtils;
import Utilities.TextUtils;
import Utilities.VectorUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.text.Segment;
import kernal.Tokenizers.TokenizerRegistryItem;

public class Tokenizer {
    public Comment[] comments = null;
    protected Quotation[] quotations = null;
    protected Escape[] escapes = null;
    public String name = "untitled";
    public String filepath = null;
    public static boolean _languageProfile = false;
    public static final String UNKNOWN_FUNCTION = "unknown";
    public static final String LANGUAGE = "language";
    public static final String DATATYPE = "datatype";
    public static final String MACRO = "macro";
    public static final String FUNCTION = "function";
    public static final String DATAMODIFIER = "datamodifier";
    public static final int UNKNOWN_FUNCTION_ID = 0;
    public static final int LANGUAGE_ID = 1;
    public static final int DATATYPE_ID = 2;
    public static final int MACRO_ID = 3;
    public static final int FUNCTION_ID = 4;
    public static final int DATAMODIFIER_ID = 5;
    public static final String VERSION = "Tokenizer v1.5 [10 September 2000]";
    public static final char ERROR = '\u0000';
    public static final String DEFAULT_DELIMITORS = "\n\t :;,.[]{}<>()";
    public static final String DEFAULT_ARITHMETIC_DELIMITORS = "*-+=/";
    public static final String DEFAULT_SPECIAL_DELIMITORS = "/$&?@%~!";
    public static final String DEFAULT_WHITE_DELIMITORS = "\n\t ";
    public boolean getNextStr_return_delimitor = false;
    public static final int INT = 1;
    public static final int DOUBLE = 2;
    public static final int STRING = 3;
    public static final int TOKEN = 4;
    public static final int kNewline = 10;
    public static final int kOpenBracket = 91;
    public static final int kCloseBracket = 93;
    public static final int kOpenParenthesis = 40;
    public static final int kCloseParenthesis = 41;
    public static final int kSpace = 32;
    public static final int kHash = 35;
    public static final int kDollar = 36;
    public static final int kDot = 46;
    public static final int kQuotes = 34;
    public static final int kQuote = 39;
    public static final int kMinusSign = 45;
    public static final int kPlusSign = 43;
    public static final int kCarReturn = 13;
    public static final int kTab = 9;
    public static final int kColon = 58;
    public static final int kSemiColon = 59;
    public static final int kFSlash = 47;
    public static final int kBSlash = 92;
    public static final int kAsterix = 42;
    public static final int kEquals = 61;
    public static final int kPercent = 37;
    public static final int kTilde = 94;
    public static final int kAmpersand = 38;
    public static final int kQuestion = 63;
    public static final int kSnail = 64;
    public static final int kOpenCurly = 123;
    public static final int kCloseCurly = 125;
    public static final int kComma = 44;
    public static final int kOpenArrowBracket = 60;
    public static final int kCloseArrowBracket = 62;
    public static final int kUnderLine = 95;
    public static final int kLeftSingleQuote = 96;
    protected static final char[] DEFAULT_ESCAPES;
    private int index = 0;
    private int offset = 0;
    protected int totalbytes = 0;
    protected char[] mBuff = null;
    protected boolean mEndOfBuffer = false;
    public boolean getCR_Newlines = false;
    protected StringBuffer outBuff = new StringBuffer();
    public boolean inError = false;
    public String delimitors = null;
    public boolean debug = false;
    public boolean grabCSystemHeader = true;
    public boolean grabComments = true;
    private static Hashtable<String[], TokenizerRegistryItem> registry;
    public boolean debug_getNextStr = false;
    public boolean showOffset = false;
    public boolean doErrors = false;
    public boolean debugTokenizer = false;
    public boolean debug_stringSearch = false;
    public boolean getComments = false;
    public Vector<ClassInterfaceSpan> listOfClassInterfaceSpans = new Vector();
    protected String[] lpAccessSpecifiers = new String[]{"public", "private", "protected", "static", "abstract", "namespace"};
    int syntaxLength = 0;

    public static void addToRegistry(Class cls, String[] ext, Comment[] cmnts, String delim) {
        if (ext == null) {
            return;
        }
        TokenizerRegistryItem[] tgi = Tokenizer.getAllMembers();
        String name = cls.getName();
        for (int n = 0; n < tgi.length; ++n) {
            if (!tgi[n].cls.getName().equals(name)) continue;
            return;
        }
        TokenizerRegistryItem item = new TokenizerRegistryItem();
        item.cls = cls;
        item.ext = ext;
        item.cmnt = cmnts;
        item.delimitor = delim;
        registry.put(ext, item);
    }

    public static TokenizerRegistryItem[] getAllMembers() {
        Enumeration<String[]> e = registry.keys();
        Vector<TokenizerRegistryItem> list = new Vector<TokenizerRegistryItem>();
        while (e.hasMoreElements()) {
            String[] key = e.nextElement();
            TokenizerRegistryItem ele = registry.get(key);
            if (ele == null) continue;
            list.addElement(ele);
        }
        TokenizerRegistryItem[] out = new TokenizerRegistryItem[list.size()];
        for (int n = 0; n < out.length; ++n) {
            out[n] = (TokenizerRegistryItem)list.elementAt(n);
        }
        return out;
    }

    public static TokenizerRegistryItem getMemberWithExt(String ext) {
        TokenizerRegistryItem[] reg = Tokenizer.getAllMembers();
        for (int n = 0; n < reg.length; ++n) {
            TokenizerRegistryItem tgi = reg[n];
            for (int i = 0; i < tgi.ext.length; ++i) {
                if (!tgi.ext[i].equals(ext)) continue;
                return tgi;
            }
        }
        return null;
    }

    public static synchronized Tokenizer getInstanceByClassName(String name) {
        Constructor<?> constr = null;
        Tokenizer tok = null;
        try {
            Class<?> cls = Class.forName(name);
            constr = cls.getConstructor(new Class[0]);
            tok = (Tokenizer)constr.newInstance(new Object[0]);
            return tok;
        }
        catch (Exception e) {
            Cutter.setLog("    Exception:Tokenizer.getInstanceByClassName() + " + e.toString());
            return null;
        }
    }

    public Tokenizer() {
    }

    public Tokenizer(String filepath) throws FileNotFoundException, IOException {
        this();
        String str;
        this.filepath = filepath;
        FileReader reader = new FileReader(filepath);
        File info = new File(filepath);
        int numbytes = (int)info.length();
        LineNumberReader lnr = new LineNumberReader(reader);
        StringBuffer buff = new StringBuffer(numbytes);
        while ((str = lnr.readLine()) != null) {
            buff.append(str).append('\n');
        }
        lnr.close();
        reader.close();
        this.totalbytes = buff.length();
        this.mBuff = new char[this.totalbytes];
        buff.getChars(0, this.totalbytes, this.mBuff, 0);
        this.index = 0;
        this.offset = 0;
        this.mEndOfBuffer = false;
    }

    public Tokenizer(Segment segment) {
        this();
        this.mBuff = segment.array;
        this.totalbytes = segment.count;
        this.offset = segment.offset;
        this.index = segment.offset;
        this.mEndOfBuffer = false;
    }

    public void setBuffer(Segment segment) {
        this.mBuff = segment.array;
        if (segment.count == 0) {
            this.mEndOfBuffer = true;
            this.totalbytes = 0;
            this.index = 0;
            return;
        }
        this.totalbytes = segment.count;
        this.offset = segment.offset;
        this.index = segment.offset;
        this.mEndOfBuffer = false;
    }

    public void setBuffer(String inStr) {
        if (inStr.length() == 0) {
            this.mEndOfBuffer = true;
            this.totalbytes = 0;
            this.index = 0;
            return;
        }
        this.mBuff = new char[inStr.length()];
        inStr.getChars(0, inStr.length(), this.mBuff, 0);
        if (this.mBuff.length == 0) {
            this.mEndOfBuffer = true;
            this.totalbytes = 0;
            this.index = 0;
            return;
        }
        this.totalbytes = this.mBuff.length;
        this.index = 0;
        this.offset = 0;
        if (this.debug) {
            System.out.println("Tokenizer.setBuffer(), index = " + this.index + " totalbytes = " + this.totalbytes);
        }
        this.mEndOfBuffer = false;
    }

    public void setBuffer(StringBuffer sb) {
        this.mBuff = new char[sb.length()];
        sb.getChars(0, sb.length(), this.mBuff, 0);
        if (this.mBuff.length == 0) {
            this.mEndOfBuffer = true;
            this.totalbytes = 0;
            this.index = 0;
            return;
        }
        this.totalbytes = this.mBuff.length;
        this.offset = 0;
        this.index = 0;
        this.mEndOfBuffer = false;
    }

    public void setBuffer(char[] inChars) {
        this.setBuffer(inChars, inChars.length);
    }

    public void setBuffer(char[] inChars, int actualLength) {
        this.mBuff = inChars;
        if (this.mBuff.length == 0) {
            this.mEndOfBuffer = true;
            this.totalbytes = 0;
            this.index = 0;
            return;
        }
        this.totalbytes = actualLength;
        this.offset = 0;
        this.index = 0;
        this.mEndOfBuffer = false;
    }

    public void setBufferLength(int trimTo) {
        if (this.totalbytes < trimTo) {
            return;
        }
        this.totalbytes = trimTo;
        this.offset = 0;
        this.index = 0;
        this.mEndOfBuffer = false;
    }

    public char[] getBuffer() {
        return this.mBuff;
    }

    public char[] getBuffer(int from) {
        if (this.getBufferLength() - from < 0) {
            return null;
        }
        char[] out = new char[this.getBufferLength() - from];
        int oldIndex = this.getBufferIndex();
        this.setBufferIndex(from);
        for (int n = 0; n < out.length; ++n) {
            out[n] = this.readChar();
        }
        this.setBufferIndex(oldIndex);
        return out;
    }

    public char[] getBuffer(int from, int to) {
        int range = to + 1 - from;
        if (range <= 0) {
            char[] errorOut = new char[]{'\u0000'};
            return errorOut;
        }
        char[] out = new char[range];
        int oldIndex = this.getBufferIndex();
        this.setBufferIndex(from);
        for (int n = 0; n < out.length; ++n) {
            out[n] = this.readChar();
        }
        this.setBufferIndex(oldIndex);
        return out;
    }

    public String removeFromBuffer(int from, int to) {
        int bufflen = this.getBufferLength();
        if (bufflen == 0) {
            return "";
        }
        if (from > bufflen || to > bufflen) {
            return "";
        }
        int preEnd = from > 0 ? from - 1 : from;
        char[] pre = from == 0 ? null : this.getBuffer(0, preEnd);
        char[] piece = this.getBuffer(from, to - 1);
        int postBegin = to;
        char[] post = this.getBuffer(postBegin);
        StringBuffer buf = new StringBuffer();
        boolean lastCharIsSpace = false;
        if (pre != null && pre.length > 0) {
            buf.append(pre);
            int lastCharIndex = pre.length > 0 ? pre.length - 1 : 0;
            char lastChar = pre[lastCharIndex];
            lastCharIsSpace = Character.isWhitespace(lastChar);
        }
        boolean firstCharIsSpace = false;
        if (post != null && post.length > 0) {
            char firstChar = post[0];
            firstCharIsSpace = Character.isWhitespace(firstChar);
        }
        if (!lastCharIsSpace && !firstCharIsSpace) {
            buf.append(' ');
        }
        buf.append(post);
        this.setBuffer(buf.toString());
        this.setBufferIndex(from);
        if (piece == null) {
            return "";
        }
        return new String(piece);
    }

    public int getBufferLength() {
        return this.totalbytes;
    }

    public final int getBufferIndex() {
        return this.index - this.offset;
    }

    public final void setBufferIndex(int index) {
        this.index = index + this.offset;
        this.mEndOfBuffer = this.index >= this.totalbytes + this.offset;
    }

    public void rewindBuffer() {
        this.index = this.offset;
        this.mEndOfBuffer = false;
    }

    public String toString() {
        if (this.getBufferLength() == 0) {
            return "";
        }
        return new String(this.getBuffer());
    }

    public void rewindBuffer(int index) {
        if (index > this.totalbytes + this.offset || index < this.offset) {
            this.rewindBuffer();
        }
        this.index = index + this.offset;
    }

    public void moveBufferIndex(int delta) {
        this.index += delta;
    }

    public String _getNextStr() {
        this.outBuff.setLength(0);
        char c = this.readChar();
        while (!this.mEndOfBuffer && this.isDelimitor(c)) {
            if (this.getNextStr_return_delimitor) {
                return "" + c;
            }
            c = this.readChar();
        }
        while (!this.mEndOfBuffer) {
            this.outBuff.append(c);
            c = this.readChar();
            if (!this.isDelimitor(c)) continue;
            if (!this.getNextStr_return_delimitor) {
                this.ungetChar();
                return this.outBuff.toString();
            }
            return this.outBuff.toString();
        }
        return this.outBuff.toString();
    }

    public String getNextStr() {
        String cmnt;
        String sysHdr;
        boolean literal = false;
        boolean endOfString = false;
        this.debug = false;
        this.outBuff.setLength(0);
        char c = this.gnsGrabNonWhiteChar();
        if (c == '\u0000') {
            return "";
        }
        this.outBuff.append(c);
        if (this.grabCSystemHeader && (sysHdr = this.gnsGrabCSystemHeader(c)) != null) {
            return sysHdr;
        }
        if (this.grabComments && (cmnt = this.gnsGrabComment(c)) != null) {
            return cmnt;
        }
        String esc = this.gnsGrabEscape(c);
        if (esc != null) {
            return esc;
        }
        if (this.isDelimitor(c)) {
            return this.outBuff.toString();
        }
        Quotation activeQuote = this.isOpenQuotation(c);
        boolean bl = literal = activeQuote != null;
        while (!endOfString && !this.mEndOfBuffer) {
            c = this.readChar();
            if (c == '\u0000') {
                return this.outBuff.toString();
            }
            if (literal && activeQuote.isCloseQuotation(c)) {
                return this.outBuff.append(c).toString();
            }
            if (!literal && this.isOpenQuotation(c) != null) {
                this.ungetChar();
                return this.outBuff.toString();
            }
            if (this.gnsPeekEscape(c)) {
                if (literal) {
                    this.outBuff.append(this.gnsGrabEscape(c));
                    continue;
                }
                this.ungetChar();
                return this.outBuff.toString();
            }
            if (literal) {
                this.outBuff.append(c);
                continue;
            }
            if (this.isDelimitor(c)) {
                this.ungetChar();
                return this.outBuff.toString();
            }
            this.outBuff.append(c);
        }
        return this.outBuff.toString();
    }

    public boolean isComment(String str) {
        if (this.comments == null) {
            return false;
        }
        for (int n = 0; n < this.comments.length; ++n) {
            if (!this.comments[n].isOpenComment(str)) continue;
            return true;
        }
        return false;
    }

    public String gnsGrabComment(char c) {
        if (this.comments == null) {
            return null;
        }
        boolean found = false;
        for (int n = 0; n < this.comments.length; ++n) {
            if (this.comments[n].openStr.charAt(0) != c) continue;
            found = true;
        }
        if (!found) {
            return null;
        }
        String peekStr = "";
        StringBuffer sb = new StringBuffer();
        for (int n = 0; n < this.comments.length; ++n) {
            peekStr = "";
            if (this.comments[n].openLen > 1) {
                char[] peek = this.peekNextChars(this.comments[n].openLen - 1);
                if (peek == null) {
                    return "" + c;
                }
                peekStr = new String(peek);
            }
            if (!this.comments[n].isOpenComment(c + peekStr)) continue;
            sb.append(c + peekStr);
            this.setBufferIndex(this.getBufferIndex() + (this.comments[n].openLen - 1));
            c = this.readChar();
            while (c != '\u0000') {
                sb.append(c);
                if (sb.toString().endsWith(this.comments[n].closeStr)) {
                    return sb.toString();
                }
                c = this.readChar();
            }
            return sb.toString();
        }
        return null;
    }

    public String gnsGrabEscape(char c) {
        if (this.escapes == null) {
            return null;
        }
        String peekStr = "";
        StringBuffer sb = new StringBuffer();
        for (int n = 0; n < this.escapes.length; ++n) {
            if (this.escapes[n].openLen > 1) {
                char[] peek = this.peekNextChars(this.escapes[n].openLen - 1);
                if (peek == null) {
                    return null;
                }
                peekStr = new String(peek);
            }
            if (!this.escapes[n].isOpenEscape(c + peekStr)) continue;
            sb.append(c).append(peekStr);
            this.setBufferIndex(this.getBufferIndex() + (this.escapes[n].openLen - 1));
            return sb.toString();
        }
        return null;
    }

    public boolean gnsPeekEscape(char c) {
        if (this.escapes == null) {
            return false;
        }
        String peekStr = "";
        for (int n = 0; n < this.escapes.length; ++n) {
            if (this.escapes[n].openLen > 1) {
                char[] peek = this.peekNextChars(this.escapes[n].openLen - 1);
                if (peek == null) {
                    return false;
                }
                peekStr = new String(peek);
            }
            if (!this.escapes[n].isOpenEscape(c + peekStr)) continue;
            return true;
        }
        return false;
    }

    public char gnsGrabNonWhiteChar() {
        char c = this.readChar();
        if (c == '\u0000') {
            return '\u0000';
        }
        if (this.isSpace(c)) {
            return this.removeSpace();
        }
        return c;
    }

    public String gnsGrabCSystemHeader(char c) {
        StringBuffer sb = new StringBuffer();
        if (c == '<' && !this.isSpace(this.peekNextChar())) {
            sb.append(c);
            int offset = this.getBufferIndex();
            c = this.readChar();
            if (c == '\u0000') {
                return sb.toString();
            }
            do {
                if (Character.isWhitespace(c)) {
                    return sb.append(c).toString();
                }
                if (c == '/' && this.peekNextChar() == '*') {
                    this.ungetChar();
                    return sb.toString();
                }
                sb.append(c);
                if (c != '>') continue;
                return sb.toString();
            } while ((c = this.readChar()) != '\u0000');
            this.setBufferIndex(offset);
            return sb.toString();
        }
        return null;
    }

    public String getNextLiteral() {
        String oldDelims = this.delimitors;
        String str = this.getNextStr();
        while (!str.equals("") && str.trim().length() == 0) {
            str = this.getNextStr();
        }
        this.setDelimitor(oldDelims);
        return str;
    }

    protected boolean isSpace(char c) {
        if (this.getCR_Newlines && c == '\n') {
            return false;
        }
        return Character.isWhitespace(c);
    }

    protected boolean isDelimitor(char c) {
        return this.delimitors != null && this.delimitors.indexOf(c) != -1;
    }

    protected boolean isDelimitor(char c, String delim) {
        return delim != null && delim.indexOf(c) != -1;
    }

    public boolean isDefaultDelimitor(char c) {
        return DEFAULT_DELIMITORS.indexOf(c) != -1;
    }

    public void removeDelimitor(String str) {
        if (this.delimitors == null) {
            return;
        }
        StringBuffer buf = new StringBuffer(this.delimitors.length());
        for (int n = 0; n < this.delimitors.length(); ++n) {
            if (TextUtils.contains(str, this.delimitors.charAt(n))) continue;
            buf.append(this.delimitors.charAt(n));
        }
        this.delimitors = new String(buf);
    }

    public void setDelimitor(String sep) {
        this.delimitors = sep == null ? null : new String(sep);
    }

    public void setDefaultDelimitors() {
        this.delimitors = DEFAULT_DELIMITORS;
    }

    public String getDelimitors() {
        return this.delimitors;
    }

    public void appendDelimitor(String sep) {
        this.removeDelimitor(sep);
        if (sep != null) {
            this.delimitors = this.delimitors + sep;
        }
    }

    public String getValueForToken(String token, boolean ignoreCase) {
        int[] offset = this.stringSearch(token, ignoreCase);
        if (offset == null) {
            return null;
        }
        this.setBufferIndex(offset[1]);
        return this.getNextLiteral();
    }

    public char setCharAt(char in, int index) {
        char out;
        try {
            out = this.mBuff[index];
            this.mBuff[index] = in;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Cutter.setLog("    Error: Tokenizer.setCharAt() index = " + index + ", totalbytes = " + this.totalbytes + "\n" + e);
            return '\u0000';
        }
        return out;
    }

    public char readChar() {
        char c = '\u0000';
        if (this.mEndOfBuffer) {
            return '\u0000';
        }
        try {
            c = this.mBuff[this.index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Cutter.setLog("    Error: Tokenizer.readChar() index = " + this.index + ", totalbytes = " + this.totalbytes + ", offset = " + this.offset + "\n" + e);
            return '\u0000';
        }
        ++this.index;
        if (this.index >= this.totalbytes + this.offset) {
            this.mEndOfBuffer = true;
        }
        return c;
    }

    public void ungetChar() {
        if (this.index >= 1) {
            --this.index;
        }
        if (this.index < this.totalbytes + this.offset) {
            this.mEndOfBuffer = false;
        }
    }

    public boolean endOfBuffer() {
        return this.mEndOfBuffer;
    }

    public static boolean equalStrings(String str1, String str2) {
        if ((str1.startsWith("\n") || str1.startsWith("\r")) && str1.length() > 1) {
            str1 = str1.substring(1, str1.length());
        }
        if ((str2.startsWith("\n") || str2.startsWith("\r")) && str2.length() > 1) {
            str2 = str2.substring(1, str2.length());
        }
        if ((str1.endsWith("\n") || str1.endsWith("\r")) && str1.length() > 1) {
            str1 = str1.substring(0, str1.length() - 1);
        }
        if ((str2.endsWith("\n") || str2.endsWith("\r")) && str2.length() > 1) {
            str2 = str2.substring(0, str2.length() - 1);
        }
        return str1.equalsIgnoreCase(str2);
    }

    public static void makeLowerCase(String inStr, String outStr) {
        outStr = inStr.toLowerCase();
    }

    public static String addQuotations(String input) {
        String temp = new String();
        temp.concat(input.toString());
        return temp;
    }

    public void ungetString(String str) {
        int newIndex = this.index - (str.length() + 1);
        if (newIndex - this.offset < 0) {
            newIndex = 0;
        }
        this.rewindBuffer(newIndex);
    }

    public String _removeCommentedText() {
        int oldIndex = this.getBufferIndex();
        this.setBufferIndex(0);
        StringBuffer b = new StringBuffer();
        String s = this.getNextStr();
        while (!s.equals("")) {
            if (!this.isComment(s)) {
                b.append(s).append(" ");
            }
            s = this.getNextStr();
        }
        this.setBufferIndex(oldIndex);
        return b.toString();
    }

    public char peekNextChar() {
        if (this.index - this.offset >= this.totalbytes) {
            return '\u0000';
        }
        return this.mBuff[this.index];
    }

    public String peekNextStr() {
        int currentIndex = this.getBufferIndex();
        String str = this.getNextStr();
        this.setBufferIndex(currentIndex);
        return str;
    }

    public char[] peekNextChars(int num) {
        if (num < 0) {
            return null;
        }
        if (this.index - this.offset + num > this.totalbytes) {
            return null;
        }
        char[] out = new char[num];
        for (int n = 0; n < num; ++n) {
            out[n] = this.mBuff[this.index + n];
        }
        return out;
    }

    public char peekPrevChar() {
        if (this.index == 0) {
            return '\u0000';
        }
        return this.mBuff[this.index - 1];
    }

    public char peekPrevChar(int n) {
        if (this.index - n < 0) {
            return '\u0000';
        }
        return this.mBuff[this.index - n];
    }

    public char peekAtChar(int atIndex) {
        if (this.index - this.offset + atIndex < 0 || this.index - this.offset + atIndex == this.totalbytes) {
            return '\u0000';
        }
        return this.mBuff[atIndex + this.offset];
    }

    public char peekAtChar() {
        if (this.index - this.offset < 0 || this.index - this.offset == this.totalbytes) {
            return '\u0000';
        }
        return this.mBuff[this.index];
    }

    public int peekIndexNextNonWhite(int offset) {
        for (int n = offset; n < this.mBuff.length; ++n) {
            if (this.isSpace(this.mBuff[n])) continue;
            return n;
        }
        return -1;
    }

    public char peekNextNonWhite(int offset) {
        for (int n = offset; n < this.mBuff.length; ++n) {
            if (this.isSpace(this.mBuff[n])) continue;
            return this.mBuff[n];
        }
        return '\u0000';
    }

    public int peekNextWhiteChar(int offset) {
        for (int n = offset; n < this.mBuff.length; ++n) {
            if (!this.isSpace(this.mBuff[n])) continue;
            return n;
        }
        return -1;
    }

    public char peekNextNonWhite() {
        for (int n = this.index; n < this.mBuff.length; ++n) {
            if (this.isSpace(this.mBuff[n])) continue;
            return this.mBuff[n];
        }
        return '\u0000';
    }

    public boolean nextNonWhiteCharIs(int charCode) {
        for (int n = this.index; n < this.mBuff.length; ++n) {
            if (this.isSpace(this.mBuff[n])) continue;
            return this.mBuff[n] == charCode;
        }
        return false;
    }

    public int peekNextCharIndex(int charCode, int offset) {
        for (int n = offset; n < this.mBuff.length; ++n) {
            if (this.mBuff[n] != charCode) continue;
            return n;
        }
        return -1;
    }

    public int peekNextNonWhiteIndex(int offset) {
        for (int n = offset; n < this.mBuff.length; ++n) {
            if (this.isSpace(this.mBuff[n])) continue;
            return n;
        }
        return -1;
    }

    public int peekPrevNonWhite(int offset) {
        for (int n = offset; n >= 0; --n) {
            if (this.isSpace(this.mBuff[n])) continue;
            return n;
        }
        return -1;
    }

    public int peekPrevWhite(int offset) {
        for (int n = offset; n >= 0; --n) {
            if (!this.isSpace(this.mBuff[n])) continue;
            return n;
        }
        return -1;
    }

    public int peekDoubleColon(int offset) {
        int currentOffset = this.getBufferIndex();
        this.setBufferIndex(offset);
        String s = this.getNextStr();
        int nextOffset = this.getBufferIndex();
        this.setBufferIndex(currentOffset);
        if (s.equals(":") && this.peekNextChar() == ':') {
            return nextOffset + 1;
        }
        return -1;
    }

    public char readPrevChar() {
        if (this.index < 0) {
            this.mEndOfBuffer = true;
            return '\u0000';
        }
        char c = this.mBuff[this.index];
        --this.index;
        if (c == '\n' || c == '\r') {
            c = '\n';
        }
        return c;
    }

    protected char removeSpace() {
        char c = this.readChar();
        if (c == '\u0000') {
            return '\u0000';
        }
        if (this.mEndOfBuffer) {
            if (this.isSpace(c)) {
                return '\u0000';
            }
            return c;
        }
        while (this.isSpace(c)) {
            if (this.mEndOfBuffer) {
                return '\u0000';
            }
            c = this.readChar();
            if (c != '\u0000') continue;
            return '\u0000';
        }
        return c;
    }

    public static String cleanDigit(String digitStr) {
        if (digitStr.length() <= 1) {
            return digitStr;
        }
        if (!Character.isDigit(digitStr.charAt(0))) {
            while (!Character.isDigit(digitStr.charAt(0))) {
                digitStr = digitStr.substring(1, digitStr.length());
            }
        }
        if (!Character.isDigit(digitStr.charAt(digitStr.length() - 1))) {
            while (!Character.isDigit(digitStr.charAt(digitStr.length() - 1))) {
                digitStr = digitStr.substring(0, digitStr.length() - 1);
            }
        }
        return digitStr;
    }

    public static int isOfType(String str) {
        boolean isFloat = false;
        if (str.length() == 0) {
            return 0;
        }
        if (str.charAt(0) == '\"' || str.charAt(0) == '.' && str.length() > 1 && str.charAt(1) == '.') {
            return 3;
        }
        if (Character.isDigit(str.charAt(0)) || str.charAt(0) == '.' || str.charAt(0) == '-') {
            for (int k = 0; k < str.length(); ++k) {
                if (str.charAt(k) != '.') continue;
                isFloat = true;
            }
            if (isFloat) {
                return 2;
            }
            return 1;
        }
        return 4;
    }

    public static boolean isLiteral(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        return str.charAt(0) == '\"' && str.charAt(str.length() - 1) == '\"';
    }

    public static String removeQuotes(String str) {
        if (Tokenizer.isLiteral(str)) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    public int replaceString(String target, String replacement, boolean ignoreCase) {
        int n;
        int currentIndex = this.index;
        this.rewindBuffer();
        int headLength = this.searchFor(target, false);
        if (headLength == -1) {
            return headLength;
        }
        char[] temp = new char[this.totalbytes - target.length() + replacement.length()];
        System.arraycopy(this.mBuff, 0, temp, 0, headLength);
        for (n = 0; n < replacement.length(); ++n) {
            temp[headLength + n] = replacement.charAt(n);
        }
        int remainder = this.mBuff.length - (target.length() + headLength);
        int destOffset = headLength + replacement.length();
        int srcOffset = this.totalbytes - remainder;
        char[] test = new char[remainder];
        for (n = 0; n < remainder - 1; ++n) {
            temp[destOffset + n] = this.mBuff[srcOffset + n + 1];
        }
        this.mBuff = temp;
        this.totalbytes = this.mBuff.length;
        return destOffset;
    }

    public int searchFor(String pattern, boolean findEndOf) {
        int[] offset = this.stringSearch(pattern, true);
        if (offset == null) {
            return -1;
        }
        this.setBufferIndex(offset[1]);
        if (findEndOf) {
            return offset[1];
        }
        return offset[0];
    }

    public int[] searchFor(String[] strs, boolean ignoreCase, boolean wholeWord) {
        return this.searchFor(strs, ignoreCase, wholeWord, false);
    }

    public int[] searchFor(String[] strs, boolean ignoreCase, boolean wholeWord, boolean terminateAtDelimitor) {
        int[] offsets = null;
        switch (strs.length) {
            case 1: {
                offsets = this.searchFor(strs[0], ignoreCase, wholeWord);
                break;
            }
            case 2: {
                double max;
                double min;
                try {
                    Double min_d = Double.valueOf(strs[0]);
                    Double max_d = Double.valueOf(strs[0]);
                    min = min_d;
                    max = max_d;
                }
                catch (NumberFormatException e) {
                    Cutter.setLog("    Error: Tokenizer.searchFor() - search strings - \n" + strs[0] + " and " + strs[1] + "\nAre not numbers!");
                    return null;
                }
                offsets = this.searchFor(min, max, terminateAtDelimitor);
                break;
            }
            case 3: {
                double max;
                double min;
                offsets = this.searchFor(strs[0], ignoreCase, wholeWord);
                if (offsets == null) {
                    return null;
                }
                if (strs[1].length() == 0 || strs[2].length() == 0) {
                    JOptionPane.showMessageDialog(KDesktop.desktopPane, "The Find/Replace Tool cannot complete a \"Find Special\" search\nunless both the \"min\" and \"max\" fields have numbers.\n", "Missing Find Numbers", 0);
                    return null;
                }
                this.moveBufferIndex(strs[0].length());
                try {
                    min = NumberUtils.strToDouble(strs[1]);
                    max = NumberUtils.strToDouble(strs[2]);
                }
                catch (NumberFormatException e) {
                    Cutter.setLog("    Error: Tokenizer.searchFor() code 2");
                    return null;
                }
                offsets = this.searchFor(min, max, true);
                if (offsets != null) break;
            }
        }
        return offsets;
    }

    public int[] searchFor(String pattern, boolean ignoreCase, boolean wholeWord) {
        if (wholeWord) {
            return this.stringSearch(pattern, ignoreCase);
        }
        return this.charSearch(pattern, ignoreCase);
    }

    public int[] searchFor(double min, double max, boolean terminate) {
        Double val;
        this.setDelimitor(DEFAULT_DELIMITORS);
        String str = this.getNextStr();
        int[] out = new int[2];
        boolean num = false;
        while (!this.mEndOfBuffer && str.equals("")) {
            str = this.getNextStr();
        }
        while (!this.mEndOfBuffer) {
            val = TextUtils.toDouble(str);
            if (val != null) {
                Cutter.setLog("converted value = >" + val + "< comparing to min: " + min + " and max: " + max);
            }
            if (val != null && val >= 0.0 && val >= min && val <= max || val < 0.0 && val <= min && val >= max) {
                int rewind = this.isDelimitor(this.peekPrevChar()) ? str.length() + 1 : str.length();
                for (int i = 0; i < rewind; ++i) {
                    this.ungetChar();
                }
                out[0] = this.getBufferIndex();
                out[1] = out[0] + str.length();
                return out;
            }
            if (val == null && terminate) {
                return null;
            }
            str = this.getNextStr();
        }
        if (str.length() > 0 && (val = TextUtils.toDouble(str)) != null && val >= min && val <= max) {
            int rewind = this.isDelimitor(this.peekPrevChar()) ? str.length() + 1 : str.length();
            for (int i = 0; i < rewind; ++i) {
                this.ungetChar();
            }
            out[0] = this.getBufferIndex();
            out[1] = out[0] + str.length();
            return out;
        }
        return null;
    }

    public int[] stringSearch(String pattern, boolean ignoreCase) {
        int[] out = new int[2];
        char[] ar = TextUtils.contains(pattern, DEFAULT_DELIMITORS);
        String oldDilimitors = this.getDelimitors();
        this.setDelimitor(DEFAULT_DELIMITORS);
        if (ar != null) {
            this.removeDelimitor(new String(ar));
        }
        String str = this.getNextStr();
        while (!this.mEndOfBuffer) {
            if (ignoreCase && pattern.equalsIgnoreCase(str) || !ignoreCase && pattern.equals(str)) {
                int rewind = this.isDelimitor(this.peekPrevChar()) ? pattern.length() + 1 : pattern.length();
                for (int i = 0; i < rewind; ++i) {
                    this.ungetChar();
                }
                out[0] = this.getBufferIndex();
                out[1] = out[0] + str.length();
                if (this.debug_stringSearch) {
                    Cutter.setLog("stringSearch matched >" + str + "< to >" + pattern + "<");
                }
                this.setDelimitor(oldDilimitors);
                return out;
            }
            str = this.getNextStr();
        }
        if (str.length() > 0 && (ignoreCase && pattern.equalsIgnoreCase(str) || !ignoreCase && pattern.equals(str))) {
            int rewind = this.isDelimitor(this.peekPrevChar()) ? pattern.length() + 1 : pattern.length();
            for (int i = 0; i < rewind; ++i) {
                this.ungetChar();
            }
            out[0] = this.getBufferIndex();
            out[1] = out[0] + str.length();
            this.setDelimitor(oldDilimitors);
            return out;
        }
        this.setDelimitor(oldDilimitors);
        return null;
    }

    public int[] charSearch(String pattern, boolean ignoreCase) {
        if (pattern == null || pattern.length() == 0) {
            return null;
        }
        char c = this.readChar();
        char p = pattern.charAt(0);
        char[] peekChars = null;
        int[] out = new int[2];
        String peekStr = null;
        int peekLength = pattern.length() - 1;
        if (this.mEndOfBuffer) {
            return null;
        }
        while (!this.mEndOfBuffer) {
            if (!ignoreCase && c == p || ignoreCase && Character.toLowerCase(c) == Character.toLowerCase(p)) {
                char charInt = c;
                peekChars = this.peekNextChars(peekLength);
                if (peekChars == null) {
                    return null;
                }
                peekStr = c + new String(peekChars);
                if (!ignoreCase && pattern.equals(peekStr) || ignoreCase && pattern.equalsIgnoreCase(peekStr)) {
                    out[0] = this.getBufferIndex() - 1;
                    out[1] = out[0] + pattern.length();
                    return out;
                }
            }
            c = this.readChar();
        }
        if (pattern.length() > 1) {
            return null;
        }
        if (!ignoreCase && c == p || ignoreCase && Character.toLowerCase(c) == Character.toLowerCase(p)) {
            out[0] = this.getBufferIndex() - 1;
            out[1] = out[0] + pattern.length();
            return out;
        }
        return null;
    }

    public int find(int index, char c, boolean forward) {
        if (forward) {
            return this.findForward(index, c);
        }
        return this.findBackward(index, c);
    }

    public int findNewline(int from) {
        this.setBufferIndex(from);
        while (!this.mEndOfBuffer) {
            if (this.readChar() != '\n' || this.peekPrevChar(2) == '\\') continue;
            return this.getBufferIndex() - 1;
        }
        return -1;
    }

    public int findBackward(int from, char c) {
        this.setBufferIndex(from);
        while (!this.mEndOfBuffer) {
            if (this.readPrevChar() != c) continue;
            return this.getBufferIndex() + 1;
        }
        return -1;
    }

    public int findForward(int from, char c) {
        this.setBufferIndex(from);
        while (!this.mEndOfBuffer) {
            if (this.readChar() != c) continue;
            return this.getBufferIndex() - 1;
        }
        return -1;
    }

    public boolean isUserVariable(String str) {
        return false;
    }

    public boolean isNamedSpace(String s) {
        return false;
    }

    public boolean isSystemVariable(String str) {
        return false;
    }

    public boolean isCommand(String str) {
        return false;
    }

    public boolean isFunction(String str) {
        return false;
    }

    public boolean isLanguageType(String str) {
        return false;
    }

    public boolean isShaderType(String str) {
        return false;
    }

    public boolean isDataType(String str) {
        return false;
    }

    public boolean isDataModifier(String str) {
        return false;
    }

    public boolean isModule(String str) {
        return false;
    }

    public boolean isSystemHeader(String str) {
        return str.length() > 0 && str.charAt(0) == '<' && str.charAt(str.length() - 1) == '>';
    }

    public static boolean isADouble(String str) {
        return Tokenizer.isOfType(str) == 2 || Tokenizer.isOfType(str) == 1;
    }

    public String[] getScopeTypes() {
        return null;
    }

    public String[] getAccessTypes() {
        return null;
    }

    public String[] getDataTypes() {
        return null;
    }

    public String getPragmaStr() {
        return "";
    }

    public String getProcKeyword() {
        return "";
    }

    public String[] getArgBeginEnd() {
        return null;
    }

    public String[] getImportKeywords() {
        return new String[]{""};
    }

    public String[] getSysImportBeginEnd() {
        return new String[]{"<", ">"};
    }

    public String[] getUsrImportBeginEnd() {
        return new String[]{"\"", "\""};
    }

    public ProcDBItem lpGrabProc(String str) {
        return null;
    }

    protected ProcDBItem[] lpGrabProcs(String str) {
        return null;
    }

    public boolean lpGetClassInterfaceSpans() {
        Object cis = null;
        int index = this.getBufferIndex();
        String str = this.getNextStr();
        this.listOfClassInterfaceSpans.clear();
        while (!str.equals("")) {
            this.lpGetClassInterfaceSpan(str);
            str = this.getNextStr();
        }
        if (_languageProfile) {
            for (int n = 0; n < this.listOfClassInterfaceSpans.size(); ++n) {
                ClassInterfaceSpan obj = this.listOfClassInterfaceSpans.elementAt(n);
                Cutter.setLog("Class/Interface name: " + obj.name + " " + obj.span[0] + " " + obj.span[1]);
            }
            Cutter.setLog("\n\n");
        }
        return this.listOfClassInterfaceSpans.size() > 0;
    }

    protected char lpGotoIndexOfFirst(char charA, char charB) {
        int index = this.getBufferIndex();
        char c = this.readChar();
        while (c != '\u0000') {
            if (c == charA) {
                this.setBufferIndex(this.getBufferIndex() - 1);
                return charA;
            }
            if (c == charB) {
                this.setBufferIndex(this.getBufferIndex() - 1);
                return charB;
            }
            c = this.readChar();
        }
        this.setBufferIndex(index);
        return '\u0000';
    }

    protected StringPosition[] lpGetSignature(String firstStr, int count, char[] ignoreChars, char endChar) {
        StringPosition[] out = null;
        Vector<StringPosition> v = new Vector<StringPosition>();
        v.addElement(new StringPosition(firstStr, this.getBufferIndex()));
        String str = this.getNextStr();
        int n = 1;
        boolean foundEndChar = false;
        while (!str.equals("")) {
            boolean isValid;
            boolean bl = isValid = TextUtils.contains(str, ignoreChars) == null;
            if (isValid) {
                if (str.charAt(0) == endChar) {
                    foundEndChar = true;
                }
                if (str.equals("operator")) {
                    int buffIndex = this.getBufferIndex();
                    String s = this.getNextStr();
                    str = str + " ";
                    while (!s.equals("")) {
                        str = str + s.trim();
                        s = this.getNextStr();
                        if (!s.equals("(")) continue;
                    }
                    v.addElement(new StringPosition(str.trim(), buffIndex));
                    this.setBufferIndex(buffIndex);
                } else {
                    v.addElement(new StringPosition(str, this.getBufferIndex()));
                }
                if (++n == count || foundEndChar) {
                    out = new StringPosition[n];
                    for (int j = 0; j < n; ++j) {
                        out[j] = (StringPosition)v.elementAt(j);
                    }
                    return out;
                }
            }
            if (!(str = this.getNextStr()).equals("operator")) continue;
            ignoreChars = VectorUtils.addToCharArray('=', ignoreChars);
            ignoreChars = VectorUtils.addToCharArray('!', ignoreChars);
            ignoreChars = VectorUtils.addToCharArray('+', ignoreChars);
            ignoreChars = VectorUtils.addToCharArray('-', ignoreChars);
            ignoreChars = VectorUtils.addToCharArray('/', ignoreChars);
        }
        return null;
    }

    protected void lpGetClassInterfaceSpan(String str) {
        int n;
        if (str.equals("")) {
            return;
        }
        String s = "";
        boolean doSecondCheck = true;
        for (n = 0; n < this.lpAccessSpecifiers.length; ++n) {
            if (!str.equals(this.lpAccessSpecifiers[n])) continue;
            s = this.getNextStr();
            if (n != 5 || !s.equals("eval")) break;
            s = this.getNextStr();
            doSecondCheck = false;
            break;
        }
        if (doSecondCheck) {
            for (n = 0; n < this.lpAccessSpecifiers.length; ++n) {
                if (!s.equals(this.lpAccessSpecifiers[n])) continue;
                s = this.getNextStr();
                break;
            }
        }
        if (s.equals("")) {
            return;
        }
        if (str.equals("static") && this.nextNonWhiteCharIs(123)) {
            StringBuffer sb = new StringBuffer();
            this.lpGrabProcBody("{", "}", sb);
        }
        if (!this.nextNonWhiteCharIs(123)) {
            s = this.getNextStr();
        }
        if (s.equals("")) {
            return;
        }
        ClassInterfaceSpan out = new ClassInterfaceSpan();
        out.name = s;
        while (!s.equals("")) {
            if (s.equals("(") || s.equals("=")) {
                return;
            }
            if (s.equals("{")) {
                out.span[0] = this.getBufferIndex();
                break;
            }
            s = this.getNextStr();
        }
        if (s.equals("")) {
            return;
        }
        s = this.getNextStr();
        int count = 1;
        while (!s.equals("")) {
            if (s.equals("static") && this.nextNonWhiteCharIs(123)) {
                StringBuffer sb = new StringBuffer();
                this.lpGrabProcBody("{", "}", sb);
            }
            for (int n2 = 0; n2 < this.lpAccessSpecifiers.length; ++n2) {
                if (!s.equals(this.lpAccessSpecifiers[n2])) continue;
                this.lpGetClassInterfaceSpan(s);
                break;
            }
            if (s.equals("{")) {
                ++count;
            } else if (s.equals("}")) {
                --count;
            }
            if (count == 0) {
                out.span[1] = this.getBufferIndex();
                this.listOfClassInterfaceSpans.addElement(out);
                return;
            }
            s = this.getNextStr();
        }
    }

    public String lpGrabProcParams(String openChar, String closeChar) {
        StringBuffer buff = new StringBuffer();
        int index = this.getBufferIndex();
        String str = this.getNextStr();
        if (str.equals("")) {
            this.setBufferIndex(index);
            return null;
        }
        while (this.isWholeComment(str) && !str.equals("")) {
            str = this.getNextStr();
        }
        if (str.equals(openChar)) {
            int count = 1;
            str = this.getNextStr();
            while (!str.equals("")) {
                if (str.equals(openChar)) {
                    ++count;
                } else if (str.equals(closeChar)) {
                    --count;
                } else {
                    buff.append(str).append(" ");
                }
                if (count == 0) break;
                str = this.getNextStr();
            }
            if (str.equals("")) {
                this.setBufferIndex(index);
                return null;
            }
            return buff.toString();
        }
        this.setBufferIndex(index);
        return null;
    }

    public int[] lpGrabProcBody(String openChar, String closeChar, StringBuffer buff) {
        int index = this.getBufferIndex();
        String str = this.getNextStr();
        if (str.equals("")) {
            this.setBufferIndex(index);
            return null;
        }
        while (this.isWholeComment(str) && !str.equals("")) {
            str = this.getNextStr();
        }
        if (str.equals(openChar)) {
            int count = 1;
            str = this.getNextStr();
            while (!str.equals("")) {
                if (str.equals(openChar)) {
                    ++count;
                } else if (str.equals(closeChar)) {
                    --count;
                }
                if (buff != null) {
                    buff.append(str).append(" ");
                }
                if (count == 0) break;
                str = this.getNextStr();
            }
            if (str.equals("")) {
                this.setBufferIndex(index);
                return null;
            }
            int[] out = new int[]{index, this.getBufferIndex()};
            return out;
        }
        this.setBufferIndex(index);
        return null;
    }

    public boolean lpSkip(String str, String keyword, char endChar) {
        if (!str.equals(keyword)) {
            return false;
        }
        int index = this.getBufferIndex();
        while (!this.mEndOfBuffer) {
            if (this.readChar() != endChar) continue;
            return true;
        }
        this.setBufferIndex(index);
        return false;
    }

    protected void lpGetEnclosingNameAtIndex(StringBuffer out, int at) {
        for (int j = this.listOfClassInterfaceSpans.size() - 1; j >= 0; --j) {
            ClassInterfaceSpan cis = this.listOfClassInterfaceSpans.elementAt(j);
            if (at < cis.span[0] || at > cis.span[1]) continue;
            if (out.length() == 0) {
                out.append(cis.name);
                continue;
            }
            out.append(".").append(cis.name);
        }
    }

    public void setSyntaxLength(int n) {
        this.syntaxLength = n;
    }

    public int getSyntaxLength() {
        return this.syntaxLength;
    }

    public void addEscape(String open, String close) {
        int n;
        if (this.escapes == null) {
            this.escapes = new Escape[1];
            this.escapes[0] = new Escape(open, close);
            return;
        }
        for (int n2 = 0; n2 < this.escapes.length; ++n2) {
            if (!this.escapes[n2].isOpenEscape(open) || !this.escapes[n2].isCloseEscape(close)) continue;
            return;
        }
        Vector<Escape> tmp = new Vector<Escape>();
        for (n = 0; n < this.escapes.length; ++n) {
            tmp.addElement(this.escapes[n]);
        }
        tmp.addElement(new Escape(open, close));
        this.escapes = new Escape[tmp.size()];
        for (n = 0; n < tmp.size(); ++n) {
            this.escapes[n] = (Escape)tmp.elementAt(n);
        }
    }

    public void addComment(String open, String close) {
        int n;
        if (this.comments == null) {
            this.comments = new Comment[1];
            this.comments[0] = new Comment(open, close);
            return;
        }
        for (int n2 = 0; n2 < this.comments.length; ++n2) {
            if (!this.comments[n2].isOpenComment(open) || !this.comments[n2].isCloseComment(close)) continue;
            return;
        }
        Vector<Comment> tmp = new Vector<Comment>();
        for (n = 0; n < this.comments.length; ++n) {
            tmp.addElement(this.comments[n]);
        }
        tmp.addElement(new Comment(open, close));
        this.comments = new Comment[tmp.size()];
        for (n = 0; n < tmp.size(); ++n) {
            this.comments[n] = (Comment)tmp.elementAt(n);
        }
    }

    public void removeComment(String open, String close) {
        int n;
        Comment[] cmnts = this.getComments();
        Vector<Comment> list = new Vector<Comment>();
        for (n = 0; n < cmnts.length; ++n) {
            if (cmnts[n].openStr.equals(open) && cmnts[n].closeStr.equals(close)) continue;
            list.addElement(cmnts[n]);
        }
        this.comments = new Comment[list.size()];
        for (n = 0; n < list.size(); ++n) {
            this.comments[n] = (Comment)list.elementAt(n);
        }
    }

    public Comment[] getComments() {
        return this.comments;
    }

    public void addQuotation(String open, String close, char esc_char) {
        char[] esc_chars = new char[]{esc_char};
        this.addQuotation(open, close, esc_chars);
    }

    public boolean removeQuotation(String open, String close) {
        int n;
        boolean result = false;
        if (this.quotations == null) {
            return result;
        }
        Vector<Quotation> tmp = new Vector<Quotation>();
        for (n = 0; n < this.quotations.length; ++n) {
            if (this.quotations[n].isOpenQuotation(open) && this.quotations[n].isCloseQuotation(close)) {
                result = true;
            }
            tmp.addElement(this.quotations[n]);
        }
        this.quotations = new Quotation[tmp.size()];
        for (n = 0; n < tmp.size(); ++n) {
            this.quotations[n] = (Quotation)tmp.elementAt(n);
        }
        return result;
    }

    public void addQuotation(String open, String close, char[] esc_chars) {
        int n;
        Quotation quot;
        int n2;
        if (this.quotations == null) {
            this.quotations = new Quotation[1];
            this.quotations[0] = new Quotation(open, close, esc_chars);
            return;
        }
        Vector<Quotation> tmp = new Vector<Quotation>();
        for (n2 = 0; n2 < this.quotations.length; ++n2) {
            tmp.addElement(this.quotations[n2]);
        }
        tmp.addElement(new Quotation(open, close, esc_chars));
        this.quotations = new Quotation[tmp.size()];
        for (n2 = 0; n2 < tmp.size(); ++n2) {
            this.quotations[n2] = (Quotation)tmp.elementAt(n2);
        }
        int max = 0;
        for (int n3 = 0; n3 < tmp.size(); ++n3) {
            quot = (Quotation)tmp.elementAt(n3);
            if (quot.openStr.length() <= max) continue;
            max = quot.openStr.length();
        }
        Vector<Quotation> sorted = new Vector<Quotation>();
        int tmpSize = tmp.size();
        int comparisions = 0;
        while (tmpSize > 0) {
            boolean found = false;
            for (n = 0; n < tmpSize; ++n) {
                quot = (Quotation)tmp.elementAt(n);
                ++comparisions;
                if (quot.openStr.length() < max) continue;
                sorted.addElement(quot);
                tmp.removeElementAt(n);
                tmpSize = tmp.size();
                found = true;
                break;
            }
            if (!found) {
                --max;
            }
            tmpSize = tmp.size();
        }
        this.quotations = new Quotation[sorted.size()];
        for (n = 0; n < sorted.size(); ++n) {
            this.quotations[n] = (Quotation)sorted.elementAt(n);
        }
    }

    public int getOpenCmntLength() {
        if (this.comments == null) {
            return -1;
        }
        int max = 0;
        for (int n = 0; n < this.comments.length; ++n) {
            if (this.comments[n].openLen <= max) continue;
            max = this.comments[n].openLen;
        }
        return max;
    }

    public int getCloseCmntLength() {
        if (this.comments == null) {
            return -1;
        }
        int max = 0;
        for (int n = 0; n < this.comments.length; ++n) {
            if (this.comments[n].closeLen <= max) continue;
            max = this.comments[n].closeLen;
        }
        return max;
    }

    public int findOpenComment(String str) {
        if (this.comments == null) {
            return -1;
        }
        int min = str.length();
        for (int n = 0; n < this.comments.length; ++n) {
            int offset = this.comments[n].findOpenComment(str);
            min = offset < min ? offset : min;
        }
        return min;
    }

    public static int indexOfUncommented(Tokenizer tok, String str, int begin, char c) {
        tok.setBuffer(str);
        tok.setBufferIndex(begin);
        String s = tok.getNextStr();
        while (!s.equals("")) {
            while (tok.isComment(s)) {
                s = tok.getNextStr();
            }
            if (s.length() == 1 && s.charAt(0) == c) {
                return tok.getBufferIndex() - 1;
            }
            s = tok.getNextStr();
        }
        return -1;
    }

    public int findOpenComment(Segment segment, int from) {
        if (this.comments == null) {
            return -1;
        }
        int min = segment.count;
        for (int n = 0; n < this.comments.length; ++n) {
            int offset = this.comments[n].findOpenComment(segment, from);
            min = offset < min ? offset : min;
        }
        return min;
    }

    public int findCloseComment(Segment segment, int from) {
        if (this.comments == null || segment == null) {
            return -1;
        }
        int min = segment.count;
        for (int n = 0; n < this.comments.length; ++n) {
            int offset = this.comments[n].findCloseComment(segment, from);
            min = offset < min ? offset : min;
        }
        return min;
    }

    public Comment isOpenComment(Segment segment, int from) {
        if (this.comments == null || segment == null) {
            return null;
        }
        for (int n = 0; n < this.comments.length; ++n) {
            if (!this.comments[n].isOpenComment(segment, from)) continue;
            return this.comments[n];
        }
        return null;
    }

    public Comment isOpenComment(String str, int from) {
        if (this.comments == null || str == null) {
            return null;
        }
        Segment segment = SegmentUtils.toSegment(str);
        return this.isOpenComment(segment, from);
    }

    public boolean isWholeComment(String str) {
        if (this.comments == null || str == null) {
            return false;
        }
        boolean begin = false;
        for (int n = 0; n < this.comments.length; ++n) {
            if (!this.comments[n].isOpenComment(str)) continue;
            begin = true;
            str = str.substring(this.comments[n].openLen);
            break;
        }
        if (!begin) {
            return false;
        }
        boolean close = false;
        for (int n = 0; n < this.comments.length; ++n) {
            String endStr;
            int endOffset = str.length() - this.comments[n].closeLen;
            if (endOffset < 0 || !this.comments[n].isCloseComment(endStr = str.substring(endOffset))) continue;
            close = true;
            break;
        }
        return begin && close;
    }

    public boolean isOpenComment(String str) {
        if (this.comments == null || str == null) {
            return false;
        }
        for (int n = 0; n < this.comments.length; ++n) {
            if (!this.comments[n].isOpenComment(str)) continue;
            return true;
        }
        return false;
    }

    public String[] lpGrabComment(String str) {
        if (this.comments == null || str == null) {
            return null;
        }
        String[] out = null;
        for (int n = 0; n < this.comments.length; ++n) {
            if (!this.comments[n].isOpenComment(str)) continue;
            Segment segment = new Segment(str.toCharArray(), 0, str.length());
            int index = this.comments[n].findCloseComment(segment, this.comments[n].openLen);
            if (index == -1) {
                Cutter.setLog("Tokenizer.lpGrabComment() - couldn't find closing comment for " + str);
                return null;
            }
            out = new String[]{str.substring(0, index), index >= str.length() ? "" : str.substring(index, str.length())};
        }
        return out;
    }

    public int isOpenComment(char[] chars) {
        if (this.comments == null || chars == null) {
            return 0;
        }
        for (int n = 0; n < this.comments.length; ++n) {
            if (!this.comments[n].isOpenComment(chars)) continue;
            return this.comments[n].openLen;
        }
        return 0;
    }

    public boolean isOpenComment(char c) {
        if (this.comments == null) {
            return false;
        }
        for (int n = 0; n < this.comments.length; ++n) {
            if (this.comments[n].openStr.charAt(0) != c) continue;
            return true;
        }
        return false;
    }

    public Quotation isOpenQuotation(Segment segment, int from) {
        if (this.quotations == null || segment == null) {
            return null;
        }
        for (int n = 0; n < this.quotations.length; ++n) {
            if (!this.quotations[n].isOpenQuotation(segment, from)) continue;
            return this.quotations[n];
        }
        return null;
    }

    public Quotation isOpenQuotation(char c) {
        if (this.quotations == null) {
            return null;
        }
        for (int n = 0; n < this.quotations.length; ++n) {
            if (!this.quotations[n].isOpenQuotation(c)) continue;
            return this.quotations[n];
        }
        return null;
    }

    public boolean isOpenQuotation(String str) {
        if (this.quotations == null || str == null) {
            return false;
        }
        for (int n = 0; n < this.quotations.length; ++n) {
            if (!this.quotations[n].isOpenQuotation(str)) continue;
            return true;
        }
        return false;
    }

    public int isOpenQuotation(char[] chars) {
        if (this.quotations == null || chars == null) {
            return 0;
        }
        for (int n = 0; n < this.quotations.length; ++n) {
            if (!this.quotations[n].isOpenQuotation(chars)) continue;
            return this.quotations[n].openLen;
        }
        return 0;
    }

    public Escape isOpenEscape(Segment segment, int from) {
        if (this.escapes == null || segment == null) {
            return null;
        }
        for (int n = 0; n < this.escapes.length; ++n) {
            if (!this.escapes[n].isOpenEscape(segment, from)) continue;
            return this.escapes[n];
        }
        return null;
    }

    public boolean containsAnyQuotation(String str) {
        if (this.quotations == null || str == null) {
            return false;
        }
        for (int n = 0; n < this.quotations.length; ++n) {
            if (!this.quotations[n].containsAnyQuotation(str)) continue;
            return true;
        }
        return false;
    }

    public Escape containsOpenEscape(String str) {
        if (this.escapes == null || str == null) {
            return null;
        }
        for (int n = 0; n < this.escapes.length; ++n) {
            if (!this.escapes[n].containsOpenEscape(str)) continue;
            return this.escapes[n];
        }
        return null;
    }

    public Comment containsOpenComment(String str) {
        if (this.comments == null || str == null) {
            return null;
        }
        for (int n = 0; n < this.comments.length; ++n) {
            if (!this.comments[n].containsOpenComment(str)) continue;
            return this.comments[n];
        }
        return null;
    }

    public Comment containsClosingComment(String str) {
        if (this.comments == null || str == null) {
            return null;
        }
        for (int n = 0; n < this.comments.length; ++n) {
            if (!this.comments[n].containsClosingComment(str)) continue;
            return this.comments[n];
        }
        return null;
    }

    public int isCloseComment(char[] chars) {
        if (this.comments == null || chars == null) {
            return 0;
        }
        for (int n = 0; n < this.comments.length; ++n) {
            if (!this.comments[n].isCloseComment(chars)) continue;
            return this.comments[n].closeLen;
        }
        return 0;
    }

    public Quotation isCloseQuotation(char c) {
        if (this.quotations == null) {
            return null;
        }
        for (int n = 0; n < this.quotations.length; ++n) {
            if (!this.quotations[n].isCloseQuotation(c)) continue;
            return this.quotations[n];
        }
        return null;
    }

    public Comment isCloseComment(Segment segment, int from) {
        if (this.comments == null || segment == null) {
            return null;
        }
        for (int n = 0; n < this.comments.length; ++n) {
            if (!this.comments[n].isCloseComment(segment, from)) continue;
            return this.comments[n];
        }
        return null;
    }

    public boolean isCloseComment(String str) {
        if (this.comments == null || str == null) {
            return false;
        }
        for (int n = 0; n < this.comments.length; ++n) {
            if (!this.comments[n].isCloseComment(str)) continue;
            return true;
        }
        return false;
    }

    public boolean isQuotes(char c, char prevChar) {
        if (c != '\"') {
            return false;
        }
        return prevChar != '\\';
    }

    public boolean balancedQuotations(Segment segment, int from) {
        if (this.quotations == null || segment == null) {
            return true;
        }
        for (int n = 0; n < this.quotations.length; ++n) {
            if (this.quotations[n].balancedQuotations(segment, from)) continue;
            return false;
        }
        return true;
    }

    public boolean balancedQuotations(String str) {
        if (str == null || str.trim().length() == 0) {
            return true;
        }
        for (int n = 0; n < this.quotations.length; ++n) {
            if (this.quotations[n].balancedQuotations(str)) continue;
            return false;
        }
        return true;
    }

    public boolean isPartialOpenComment(String str) {
        if (this.comments == null || str == null) {
            return false;
        }
        for (int n = 0; n < this.comments.length; ++n) {
            if (!this.comments[n].isPartialOpenComment(str)) continue;
            return true;
        }
        return false;
    }

    public boolean isEscaped(char c0, char c1) {
        if (c0 != '\\') {
            return false;
        }
        switch (c1) {
            case '\t': {
                return true;
            }
            case '\n': {
                return true;
            }
            case '\\': {
                return true;
            }
            case '\"': {
                return true;
            }
            case '\'': {
                return true;
            }
        }
        return false;
    }

    protected int count(String str, char c) {
        int num = 0;
        for (int n = 0; n < str.length(); ++n) {
            if (str.charAt(n) != c) continue;
            ++num;
        }
        return num;
    }

    static {
        try {
            Field[] fields = new Field[]{Tokenizer.class.getDeclaredField("_languageProfile")};
            Cutter.addDebug(Tokenizer.class, fields);
        }
        catch (NoSuchFieldException ex) {
            Cutter.setLog("Error: Tokenizer.static - " + ex.toString());
        }
        DEFAULT_ESCAPES = new char[]{'\t', '\n', '\\'};
        registry = new Hashtable();
    }

    public class ClassInterfaceSpan {
        public int[] span = new int[2];
        public String name = "";

        public String toString() {
            return "name: " + this.name + ", begin: " + this.span[0] + ", end: " + this.span[1];
        }
    }

    protected class StringPosition {
        public String str = "";
        public int offset = -1;

        public StringPosition() {
        }

        public StringPosition(String s, int n) {
            this.str = s;
            this.offset = n;
        }

        public boolean equals(String s) {
            return this.str.equals(s);
        }

        public int offset() {
            return this.offset;
        }

        public String toString() {
            return this.str + " at " + this.offset + "\n";
        }
    }
}

