/* 
 _CLASSNAME_Bxdf.cpp
 Generated by Cutter from:
	 "_ARGS_SOURCE_PATH_"
 at _DATE_TIME_
*/
#include "RixBxdf.h"
#include "RixRNG.h"
#include "RixShadingUtils.h"
#include "PxrSurfaceOpacity.h"
#include <cstring> // memset

class _CLASSNAME_Bxdf : public RixBxdf {
public:
	_CLASSNAME_Bxdf(RixShadingContext const *ctx, 
				RixBxdfFactory *bx, 
				RixBXLobeTraits const &lobesWanted, 
_DECLARE_CONSTRUCTOR_INPUT_POINTERS_);

    virtual RixBXEvaluateDomain GetEvaluateDomain();

    virtual void GetAggregateLobeTraits(RixBXLobeTraits *traits);

    virtual bool EmitLocal(RtColorRGB* result);

    virtual void GenerateSample(RixBXTransportTrait transportTrait,
							    RixBXLobeTraits const *lobesWanted,
							    RixRNG *rng,
							    RixBXLobeSampled *lobeSampled, 
							    RtVector3   *On, 
							    RixBXLobeWeights &W, 
							    RtFloat *FPdf, RtFloat *RPdf,
							    RtColorRGB* compTrans);

    virtual void EvaluateSample(RixBXTransportTrait transportTrait,
							    RixBXLobeTraits const *lobesWanted,
							    RixRNG *rng,
							    RixBXLobeTraits *lobesEvaluated, 
							    RtVector3 const *On, RixBXLobeWeights &W,
							    RtFloat *FPdf, RtFloat *RPdf);

    virtual void EvaluateSamplesAtIndex(RixBXTransportTrait transportTrait,
								RixBXLobeTraits const &lobesWanted, 
								RixRNG *rng,
								RtInt index, RtInt nSamples,
								RixBXLobeTraits *lobesEvaluated, 
								RtVector3 const *On, 
								RixBXLobeWeights &W,
								RtFloat *FPdf, RtFloat *RPdf);
	private:
_DECLARE_MEMBERS_AS_POINTERS_
	};

// Constructor_________________________________________
_CLASSNAME_Bxdf::_CLASSNAME_Bxdf(RixShadingContext const *ctx, 
				 			RixBxdfFactory *bx, 
				 			RixBXLobeTraits const &lobesWanted, 
_DECLARE_CONSTRUCTOR_POINTERS_): RixBxdf(ctx, bx),
_ASSIGN_CONSTRUCTOR_DEFAULTS_
	{ /* normally empty */ }

RixBXEvaluateDomain _CLASSNAME_Bxdf::GetEvaluateDomain() { 
	return k_RixBXEmptyDomain; // emissive
	}

void _CLASSNAME_Bxdf::GetAggregateLobeTraits(RixBXLobeTraits *traits) {
	*traits = k_RixBXTraitsNullLobe; // no lobes, purely emissive
	// diffuse would set,
	// *traits = m_lobesWanted;
	}

bool _CLASSNAME_Bxdf::EmitLocal(RtColorRGB* result) {
	RtInt nPts = shadingCtx->numPts;
	for(int i = 0; i < nPts; i++) 
		result[i] = m_emitColor[i];
	return true;
	}

void _CLASSNAME_Bxdf::GenerateSample(RixBXTransportTrait transportTrait,
							    RixBXLobeTraits const *lobesWanted,
							    RixRNG *rng,
							    RixBXLobeSampled *lobeSampled, 
							    RtVector3   *On, 
							    RixBXLobeWeights &W, 
							    RtFloat *FPdf, RtFloat *RPdf,
							    RtColorRGB* compTrans) {
	RtInt nPts = shadingCtx->numPts;
	for(int i = 0; i < nPts; i++) 
		lobeSampled[i].SetValid(false);
	}

void _CLASSNAME_Bxdf::EvaluateSample(RixBXTransportTrait transportTrait,
							    RixBXLobeTraits const *lobesWanted,
							    RixRNG *rng,
							    RixBXLobeTraits *lobesEvaluated, 
							    RtVector3 const *On, RixBXLobeWeights &W,
								RtFloat *FPdf, RtFloat *RPdf) {
	RtInt nPts = shadingCtx->numPts;
	for(int i = 0; i < nPts; i++) 
		lobesEvaluated[i].SetNone();
	}

void _CLASSNAME_Bxdf::EvaluateSamplesAtIndex(RixBXTransportTrait transportTrait,
								RixBXLobeTraits const &lobesWanted, 
								RixRNG *rng,
								RtInt index, RtInt nSamples,
								RixBXLobeTraits *lobesEvaluated, 
								RtVector3 const *On, 
								RixBXLobeWeights &W,
								RtFloat *FPdf, RtFloat *RPdf) {
	for(int i = 0; i < nSamples; i++) 
		lobesEvaluated[i].SetNone();
	}
// End: _CLASSNAME_Bxdf evaluator
//------------------------------------------------------------------
// Begin: _CLASSNAME_Factory RixBxdfFactory interface
class _CLASSNAME_Factory : public RixBxdfFactory {
public:
	_CLASSNAME_Factory();
	~_CLASSNAME_Factory() { }
	virtual int Init(RixContext &, char const *pluginpath);
	virtual RixSCParamInfo const *GetParamTable();
	virtual void Finalize(RixContext &) { }
	virtual void Synchronize(RixContext &ctx, 
							RixSCSyncMsg syncMsg,
							RixParameterList const *parameterList);
	virtual void CreateInstanceData(RixContext &ctx,
							char const *handle,
							RixParameterList const *plist,
							InstanceData *idata);
	virtual int GetInstanceHints(RtConstPointer instanceData) const;
	virtual RixBxdf *BeginScatter(RixShadingContext const *,
							RixBXLobeTraits const &lobesWanted,
							RixSCShadingMode sm,
							RtConstPointer instanceData);
	virtual void EndScatter(RixBxdf *ignored);
	virtual RixOpacity *BeginOpacity(RixShadingContext const *ctx,
							RixSCShadingMode shadingMode,
							RtConstPointer instancedata);
	virtual void EndOpacity(RixOpacity *ignored);
	private:
_DECLARE_MEMBERS_AS_NON_POINTERS_
	};
//------------------------------------------------------------------
// Begin: _CLASSNAME_Factory RixBxdfFactory implementation

_CLASSNAME_Factory::_CLASSNAME_Factory():
_ASSIGN_BY_VALUE_
	{ /* normally empty */ }

int _CLASSNAME_Factory::Init(RixContext &ctx, char const *pluginpath) {
	return 0;
	}

// Refer to Pixar sample code for implementation help.
void _CLASSNAME_Factory::Synchronize(RixContext &ctx, 
							RixSCSyncMsg syncMsg,
							RixParameterList const *parameterList) {  
	/*** Implementaton required ***/
	}

RixSCParamInfo const *_CLASSNAME_Factory::GetParamTable() {
	static RixSCParamInfo s_ptable[] = {
_FILL_PARAM_TABLE_
		};
	return &s_ptable[0];
	}

enum paramIds {
_FILL_PARAM_ENUMERATION_
	};
	
// Refer to Pixar sample code for implementation help. 
void _CLASSNAME_Factory::CreateInstanceData(RixContext &ctx,
							char const *handle,
							RixParameterList const *plist,
							InstanceData *idata) {
	/*** Implementaton required ***/
	return;
    }

// Refer to Pixar sample code for implementation help. 
int _CLASSNAME_Factory::GetInstanceHints(RtConstPointer instanceData) const {
	/*** Implementaton required ***/
	InstanceHints const &hints = (InstanceHints const&) instanceData;
	return hints;
	}

// Refer to Pixar sample code for implementation help. 
RixBxdf *_CLASSNAME_Factory::BeginScatter(RixShadingContext const *ctx,
							RixBXLobeTraits const &lobesWanted,
							RixSCShadingMode sm,
							RtConstPointer instanceData) {
	bool varying = true;
	bool uniform = false;
	// Declare a pointer for each input then obtain their values
	// using EvalParam().
_DECLARE_BEGIN_SCATTER_POINTERS_
_EVAL_INPUTS_

	/*** Implementaton required ***/

	RixShadingContext::Allocator pool(ctx);
	void *mem = pool.AllocForBxdf<_CLASSNAME_Bxdf>(1);

	// Must use placement new to set up the vtable properly
	// cd = Evaluator(ctx, this);  does not work when eval from allocate
	_CLASSNAME_Bxdf *eval = new (mem) _CLASSNAME_Bxdf(ctx, this, lobesWanted, 
_POINTER_NAMES_LIST_);
	return eval;
	}

void _CLASSNAME_Factory::EndScatter(RixBxdf *) { }

// Refer to Pixar sample code for implementation help. 
RixOpacity *_CLASSNAME_Factory::BeginOpacity(RixShadingContext const *ctx,
							RixSCShadingMode shadingMode,
							RtConstPointer instancedata) {
	/*** Implementaton required ***/
	return NULL;
	}

void _CLASSNAME_Factory::EndOpacity(RixOpacity *) { }

extern "C" PRMANEXPORT RixBxdfFactory *CreateRixBxdfFactory(const char *hint)
{
	return new _CLASSNAME_Factory();
}

extern "C" PRMANEXPORT void DestroyRixBxdfFactory(RixBxdfFactory *bxdf)
{
	delete((_CLASSNAME_Factory*)bxdf);
}
